/*
 *  Generator for Matrix type Content methods.
 *  The argument constr has to be a procedure which returns a
 *  
 */

DOM_ARRAY::Content_ :=
proc(constr=FAIL)
  option escape;
begin
  if constr = FAIL then constr := null() end:
  proc(Out, Array)
    local i, j, arg0, constructor, myindex, offset1, offset2, useDots;
  begin
    useDots := FALSE;
    myindex := proc(Array, idx1, idx2)
                 local res;
               begin
                 if args(0) = 2 then
                   // vector
                   res := op(Array, idx1-offset1);
                 elif args(0) = 3 then
                   // matrix
                   res := op(Array, (idx1-offset1-1)*
                             (op(arg0, [3, 2])-op(arg0, [3, 1])+1)+
                             idx2-offset2);
                 else
                   error("2 or 3 arguments expected");
                 end_if;
                 if useDots and res = 0 then hold(`&cdot;&ApplyFunction;`) else res end;
               end_proc;
    arg0 := op(Array,0);
    constructor := constr(Array);
    if op(arg0, 1) = 2 then
      // Matrix
      if op(arg0, [2, 2])-op(arg0, [2, 1]) < 0 or
        op(arg0, [3, 2])-op(arg0, [3, 1]) < 0 then
        // empty row or column
        if not strmatch(constructor, "\\.\\.") then
          // some matrix constructor
          Out::Cmatrix({"constructor"="()->".constructor."(".
                                      expr2text(op(arg0, [2, 2])-op(arg0, [2, 1])+1).", ".
                                      expr2text(op(arg0, [3, 2])-op(arg0, [3, 1])+1).")"}, [])
        else
          // has .. -> is array(a..b, ...)
          Out::Cmatrix({"constructor"="()->".expr2text(Array)}, [])
          
        end_if;
      else
        offset1 := op(arg0, [2, 1]) - 1;
        offset2 := op(arg0, [3, 1]) - 1;
        if (op(arg0, [2, 2]) - op(arg0, [2, 1]) + 1)*(op(arg0, [3, 2]) - op(arg0, [3, 1]) + 1) > 25 then
//          useDots := TRUE;
        end_if;
        Out::Cmatrix({"constructor"=constructor},
                     Out::Cmatrixrow(Out(myindex(Array,i,j)) $ j = op(arg0, 3))
                     $ i = op(arg0,2)
                    );
      end_if;
    elif op(arg0, 1) = 1 then
      // Vektor
      if op(arg0, [2, 2])-op(arg0, [2, 1]) < 0 then
        // empty vector
        Out::Cmatrix({"constructor"="()->".expr2text(Array)}, [])
      else
        offset1 := op(arg0, [2, 1]) - 1;
        Out::Cmatrix({"constructor"=constructor},
                     Out::Cmatrixrow(Out(myindex(Array, i)) $ i = op(arg0,2))
                    );
      end_if;
    elif domtype(Array) = DOM_STRING and not strmatch(Array, "\n") then
      // print output for oversized matrices
      Out::Cci(hold(``).Array);
    else
      // Fallback to ASCII output
      error("not yet implemented"):
    end_if
  end_proc:
end_proc:
DOM_HFARRAY::Content :=
DOM_ARRAY::Content_(Array -> "() -> if ".op(Array, [0, 1])." = 2 then hfarray(".expr2text(op(Array, [0, 2..nops(op(Array, 0))])).", args()) else  hfarray(".expr2text(op(Array, [0, 2..nops(op(Array, 0))])).", op(args())) end_if"):
DOM_ARRAY::Content :=
DOM_ARRAY::Content_(Array -> "() -> if ".op(Array, [0, 1])." = 2 then array(".expr2text(op(Array, [0, 2..nops(op(Array, 0))])).", args()) else  array(".expr2text(op(Array, [0, 2..nops(op(Array, 0))])).", op(args())) end_if"):
