DOM_POLY::Content     := 
  proc(Out, data : DOM_POLY)
    local list, coeffRing, varList, keepOrder, res;
  begin
    varList := op(data, 2);
    coeffRing := op(data, 3);
    if coeffRing = hold(Expr) then
      coeffRing := null()
    end_if;
    list := map(poly2list(data), expr);
    if nops(varList) = 1 then // univariate polynomial
      list := zip(list, [op(varList) $ nops(list)], 
                  (x, y) -> [op(x,1), [_power(y, op(x,2))]])
    else                      // multivariate polynomial
      list := zip(list, [varList $ nops(list)], 
                  proc(x, y) 
                    local i; 
                  begin
                     [op(x,1), select([_power(op(y, i), 
                                       op(x,[2,i])) $ 
                                    i = 1..nops(varList)],
                                   x -> x <> 1)]
                  end);
    end_if;
    list := map(list, 
                x -> if x[1] = 1 and nops(x[2]) > 0 then
                       if nops(x[2]) = 1 then op(x[2])
                       else hold(_mult)(op(x[2])) end_if
                     elif nops(x[2]) = 0 or op(x[2]) = 1 then
                       x[1]
                     elif testtype(x[1], Type::Numeric) then
                       if testtype(x[1], "_mult") then
                         hold(_mult)(op(x[2]), op(x[1]))
                       else
                         hold(_mult)(op(x[2]), x[1])
                       end_if
                     else
                        hold(_mult)(x[1],op(x[2]))
                     end_if);
    
    keepOrder := Pref::keepOrder():
    if keepOrder = DomainsOnly then
      Pref::keepOrder(Always)
    end_if;
    if nops(list) = 0 then  // 0-polynomial
      res := Out::stdFunc(hold(poly)(0, varList, coeffRing))
    elif nops(list) = 1 then
      res := Out::stdFunc(hold(poly)(op(list), varList, coeffRing))
    else
      res := Out::stdFunc(hold(poly)(hold(_plus)(op(list)), varList, coeffRing))
    end_if;

    Pref::keepOrder(keepOrder);
    res;
  end_proc:
