//    
// tonner, 23/06/98 

/*++
output::MathXMLContent -- Wrapper for Content markup
++*/

MathXMLContent := newDomain(hold(MathXMLContent)):
MathXMLContent::create_dom:=hold(MathXMLContent):
MathXMLContent::print := x -> extop(x,1):
MathXMLContent::new := 
proc()
begin
  if Pref::autoPlot() and
     map({args()}, type) = {"plotObject"} and
     MathXMLContent::usedByNotebook then
    plot(args());
    return(new(dom, hold(``), "\n", ""))
//    return(new(dom, hold(``), "\n"))
  end_if;
  dom::create(args());
end_proc:

MathXMLContent::create :=  
proc() 
  local aliasList, res, cont, printXML, Ex;
begin
  printXML := proc(muType, contExpr, muExpr)
                local fd, text, tex, floatFormat;
              begin
                fd := xmlprint::fopen(String);
                floatFormat := Pref::floatFormat("g");
                text := "";
                traperror((text := expr2text(op(muExpr))));
                if text <> "" then
                  text := "expr"=text;
                else
                  text := null()
                end_if;
                
                tex := "";
                traperror((tex := generate::TeX(op(muExpr))));
                if tex <> "" then
                  tex := "tex"=tex;
                else
                  tex := null()
                end_if;
                Pref::floatFormat(floatFormat);
                xmlprint::beginElement(fd, "math",
                                       "muType"=muType,
                                       text, tex
                                      );
                Content::printXML(contExpr, fd);
                xmlprint::endElement(fd, "math");
                xmlprint::fclose(fd);
              end_proc;
  
  if args() = null() then
    if MathXMLContent::usedByNotebook then
      new(dom, hold(``), "\n", "")
    else
      new(dom, hold(``))
    end_if;
  else
    // return MathXMLContent objects
    if domtype(args()) = Content then
      cont := args();
    else
      aliasList := _pref(hold(Alias));
      if testtype(aliasList, DOM_LIST) and op(aliasList, 1) = TRUE and
         testtype(op(aliasList, 2), DOM_PROC) then
        Content::setAliasTab(op(aliasList, 2)())
      else
        Content::setAliasTab(table())
      end_if;
    
      cont := Content::new(args());
    end_if;
    res := cont;
    if Pref::abbreviateOutput() = TRUE then
      traperror((res := Content::findAbbreviations(cont)));
    end_if;
    if traperror((Ex := Content::expr(cont))) <> 0 then
      Ex := args()
    end_if;
    return(printXML("_res", res, [Ex]));
  end_if;
end:

MathXMLContent::usedByNotebook :=
proc()
  local cl, doc;
begin
  cl:= clientObject();
  if cl::dom::slot = FAIL
    or traperror((
       doc:= cl::document();
       doc::release()
     )) <> 0 
  then // not a calc control
    TRUE
  else
    FALSE
  end_if;
end_proc():
MathXMLContent::testtype := FALSE:
MathXMLContent::create_dom := hold(MathXMLContent):
