// 

// output::fence: Put generalized parentheses around a possibly multi-line string
//  The baseline is not changed.

output::fenceSymbols := table(
                              "(" = ["(", "/ ", "| ", "\\ "],
                              ")" = [")", " \\", " |", " /"],
                              "[+" = ["[", "+- ", "|  ", "+- "],
                              "+]" = ["]", " -+", "  |", " -+"],
                              "[" = ["[", "-- ", "|  ", "-- "],
                              "]" = ["]", " --", "  |", " --"],
                              "{" = ["{", "{ ", "{ ", "{ "],
                              "}" = ["}", " }", " }", " }"],
                              "|" = ["|", "|", "|", "|"],
                              "| " = ["|", "| ", "| ", "| "],
                              " |" = ["|", " |", " |", " |"]
                              );

output::fence :=
proc(ltype: DOM_STRING, rtype: DOM_STRING,
     ex: DOM_STRING, width=-1: DOM_INT, baseline=-2: DOM_INT)
  local buf, i;
begin
  if not contains(output::fenceSymbols, ltype) then
    error("Unknown fence type '".ltype."'");
  end_if;
  if not contains(output::fenceSymbols, rtype) then
    error("Unknown fence type '".rtype."'");
  end_if;
  
  if length(ex)>0 and (ex[-1] = "\n"  or ex[-1] = "\b") then
    ex := ex[1..-2];
  end_if;
  ex := stringlib::subs(ex, "\r"="");
  
  buf := stringlib::split(ex, "\n"):

  for i from nops(buf) downto 1 do
    buf[i..i] := stringlib::split(buf[i], "\b");
  end_for:
  
  if width = -1 then
    width := max(op(map(buf, length)));
  end_if;
  if baseline = -1 then
    baseline := ceil(nops(buf)/2);
  elif baseline = -2 then
    baseline := nops(buf);
  end_if;

  case nops(buf)
    of 1 do
      buf[1][width+1..-1] := output::fenceSymbols[rtype][1];
      return(output::fenceSymbols[ltype][1].buf[1]);
      break;
    of 2 do
      if output::fenceSymbols[rtype][2] = output::fenceSymbols[rtype][3]
        and output::fenceSymbols[ltype][2] = output::fenceSymbols[ltype][3]
        then
        buf[1][width+1..-1] := output::fenceSymbols[rtype][2];
        buf[1] := output::fenceSymbols[ltype][2].buf[1];
        buf[2][width+1..-1] := output::fenceSymbols[rtype][4];
        buf[2] := output::fenceSymbols[ltype][4].buf[2];
        if baseline=1 then
          return(buf[1]."\b".buf[2]);
        else
          return(buf[1]."\n".buf[2]."\b");
        end_if;
      else
        if baseline=1 then
          buf[1][width+1..-1] := output::fenceSymbols[rtype][1];
          return(_concat(output::fenceSymbols[ltype][1],buf[1], "\b",
                         " "$length(output::fenceSymbols[rtype][1]),
                         buf[2]));
        else
          buf[2][width+1..-1] := output::fenceSymbols[rtype][1];
          return(_concat(" "$length(output::fenceSymbols[rtype][1]),
                         buf[1],"\n",
                         output::fenceSymbols[ltype][1],buf[2], "\b"));
        end_if;
      end_if;
      break;
    otherwise
      buf[1][width+1..-1] := output::fenceSymbols[rtype][2];
      buf[1] := output::fenceSymbols[ltype][2].buf[1];
      for i from 2 to nops(buf)-1 do
        buf[i][width+1..-1] := output::fenceSymbols[rtype][3];
        buf[i] := output::fenceSymbols[ltype][3].buf[i];
      end_for;
      buf[-1][width+1..-1] := output::fenceSymbols[rtype][4];
      buf[-1] := output::fenceSymbols[ltype][4].buf[-1];

      _concat((buf[i], "\n")$i=1..baseline-1,
              buf[baseline],"\b",
              (buf[i], "\n")$i=baseline+1..nops(buf));
  end_case;
end_proc:

null():

