//    

/*

    output::roman(n)

    n - positive integer

    returns n in roman notation, as a string.

*/

output::roman :=
proc(n: Type::PosInt) : DOM_STRING
  local c, d, m;
begin
    m := n div 1000;
    n := n mod 1000;
    c := n div 100;
    n := n mod 100;
    d := n div 10;
    n := n mod 10;
    _concat("M" $ m ,
	    if c in {1,2,3} then "C" $ c
	    elif c = 4 then "CD"
	    elif c in {5,6,7,8} then "D","C" $ c-5
	    elif c = 9 then "CM"
	    else ""
	    end_if,
	    
	    if d in {1,2,3} then "X" $ d
	    elif d = 4 then "XL"
	    elif d in {5,6,7,8} then "L","X" $ d-5
	    elif d = 9 then "XC"
	    else ""
	    end_if,

	    if n in {1,2,3} then "I" $ n
	    elif n = 4 then "IV"
	    elif n in {5,6,7,8} then "V","I" $ n-5
	    elif n = 9 then "IX"
	    else ""
	    end_if)
end_proc:
