/*
 *  output::subexpr:  create a list with an abbreviated output
 *                    and equations with abbreviations
 *
 *  Arguments:  ex      -- a MuPAD expression
 *              varname -- the desired basename for the abbreviations
 *
 *  Result:     a list containing the abbreviated expression ex and
 *              equations with the abbreviations
 */

output::subexpr :=
proc(ex, varname = #_ : DOM_IDENT)
  local cont, res, i;
begin
  res := FAIL;
  traperror((cont := Content(ex);
             res := Content::findAbbreviations(cont, varname)));
  if res <> FAIL then
    if Content::typString(res) = "abbreviation" then
      // the decomposition here must be in sync with the Cabbreviation encoding in Content.mu
      [Content::expr(op(res, 1)),
       Content::expr(op(res, [1+(i)*2, 2])) $ i=2..nops(res) div 2];
    else
      [Content::expr(res)];
    end_if;
  else
    [ex];
  end_if;
end_proc:
