//      

/* -----------------------------------------------------------
    Group3d -- The Group3d

    Syntax:
    Group3d(x, y<, op1, op2, ...>)

    x, y         : plot objects
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Group3d",
                       "group of graphical 3D primitives"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Group3d::new:=
  proc()
    local object, other, children, dimensions;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) <> 0 then
      error("unexpected arguments: ".expr2text(op(other)));
    end_if;

    children := object::children;

    if nops(children) = 0 then
      // empty Group2d
      return(dom::checkObject(object))
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {3} then
      error("only 2-dimensional plot objects allowed")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:
