//      

/* -----------------------------------------------------------
    Rotate2d -- a 2D rotation

    Syntax:
    Rotate2d(angle<, center = [0, 0]<, op1, op2, ...>>)

    angle        : angle of rotation (in radians)
    center       : center of rotation - list with 2 components
                                        default is the origin
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Rotate2d", "a 2D rotation"):
//-----------------------------------------------------------------
plot::Rotate2d::styleSheet := table(CenterX = 0, CenterY = 0):
//-----------------------------------------------------------------
plot::Rotate2d::hints := {Scaling = Constrained}: 
//-----------------------------------------------------------------
plot::Rotate2d::hiddenSlots({Matrix2d, Shift, ShiftX, ShiftY}):
//-----------------------------------------------------------------
// methods yet to be implemented:  convert, convert_to, expr
//-----------------------------------------------------------------
plot::Rotate2d::new:=
  proc()
    local object, other, children, dimensions, angle, dx, dy;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() and nops(other) > 0 then
      if nops(other) > 2 then
        error("unexpected arguments: ".expr2text(other[3]));
      end_if;
      if nops(other) = 2 then
        if not testtype(other[1],
                        Type::Arithmetical) then
          error("expecting an expression for the rotation angle");
        end_if;
        if (other[2])::dom::hasProp(Cat::Matrix) = TRUE then
          other[2]:= [op(other[2])];
        end_if;
        if not testtype(other[2], 
                        Type::ListOf(Type::Arithmetical, 2, 2)) then 
          error("expecting a list of 2 expressions or a matrix for the center of rotation");
        end_if;
      end_if;
      if nops(other) = 1 then 
        if not testtype(other[1],
                        Type::Arithmetical) then
          error("expecting an expression for the rotation angle");
        end_if;
      end_if;
    end_if;

    if nops(other) > 0 then
      object::Angle := other[1];
      if nops(other) = 2 then 
        object::Center  := other[2];
      end_if;
    end_if;
    
    if object::Angle = FAIL then
      error("no rotation angle specified");
    end_if;
    angle := object::Angle;
    dx := object::CenterX;
    dy := object::CenterY;

    object::Matrix2d:= [specfunc::cos(angle),  -specfunc::sin(angle),
			specfunc::sin(angle),   specfunc::cos(angle)];
    object::Shift   := [dx-specfunc::cos(angle)*dx+specfunc::sin(angle)*dy,
			dy-specfunc::sin(angle)*dx-specfunc::cos(angle)*dy];
 
    children := object::children;
    if nops(children) = 0 then
      // empty Rotate2d
      return(dom::checkObject(object))
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if dimensions <> {2} then
      error("only 2-dimensional plot objects allowed")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Rotate2d::changeNotifier :=
  proc(obj, ass)
    local slotName, newval, angle, dx, dy;
  begin
    [slotName, newval] := [op(ass)];
    case slotName
      of "CenterX" do
      of "CenterY" do
      of "Center" do
      of "Angle" do
	dom::extslot(obj, slotName, newval);
	angle := obj::Angle;
	dx := obj::CenterX;
	dy := obj::CenterY;
        obj::Matrix2d:= [specfunc::cos(angle),  -specfunc::sin(angle),
			 specfunc::sin(angle),   specfunc::cos(angle)];
	obj::Shift   := [dx-specfunc::cos(angle)*dx+specfunc::sin(angle)*dy,
			 dy-specfunc::sin(angle)*dx-specfunc::cos(angle)*dy];
	return(FALSE); // we've done everything
	break;
    end_case;
    return(TRUE); // go ahead
  end_proc:
  
plot::Rotate2d::print :=
  proc(obj)
  begin
    if obj::Center=[0,0] then
      hold(plot::Rotate2d)(obj::Angle, op(obj::children),
                           dom::printAttributes(obj, {Angle, Center})):
    else
      hold(plot::Rotate2d)(obj::Angle, Center=obj::Center, op(obj::children),
                           dom::printAttributes(obj, {Angle, Center})):
    end_if;
  end_proc:

