//      

/* -----------------------------------------------------------
    Scene3d -- The Scene3d

    Syntax:
    Scene3d(x, y<, op1, op2, ...>)

    x, y         : plot objects
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Scene3d", "primitive for 3D scenes"):

plot::Scene3d::styleSheet := table(HeaderFont="'sans-serif' 12",
                                   FooterFont="'sans-serif' 12"):
// Hints for parents:
plot::Scene3d::hints := {Lighting}:

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Scene3d::new:=
  proc()
    local object, other, children, dimensions, coords, styleEntries,
          hasLight, viewAttr, hints, views, dummy;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], op(dom::styleSheet), args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) <> 0 then
      error("unexpected arguments: ".expr2text(op(other)));
    end_if;

    children := object::children;

    if nops(children) = 0 then
      // empty plot
      object::children := [plot::CoordinateSystem3d()];
      return(dom::checkObject(object));
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {3} then
      error("only 3-dimensional plot objects allowed")
    end_if;
        
    [coords, other, dummy] := 
    split(children, x -> testtype(x, plot::CoordinateSystem3d));
    [views, other, dummy] := split(other, testtype, plot::View3d);
    coords := views.coords;

    //  are there lights left in other?
    dummy := map({op(other)}, domtype);
    hasLight := map(plot::allLights, x -> slot(plot, x)) intersect dummy <> {};

    dummy := map({op(children)}, x -> x::dom::objType) intersect
             {"Canvas", "Scene2d", "Scene3d"};
    if dummy <> {} then
      error("Illegal argument plot::".op(dummy, 1))
    end_if;
    
    if other <> [] then
      // optional attributes for children are now in styleEntries,
      // pass them to the scene creation
      styleEntries := op(map((extop(object, 1))::styleEntries, plot::ExprAttribute::getExpr));
      // same for hints (optional arguments for children given to Scene3d)
      hints := {op(map((extop(object, 1))::hints, plot::ExprAttribute::getExpr))};
      // ignore internal _-attributes
      hints := op(select(hints, x -> ("".op(x,1))[length("".op(x,1))] <> "_")):
      coords := coords.[plot::CoordinateSystem3d(op(other),
                                                 styleEntries, hints)];
    end_if;
    object::children := coords;
      
    if hasLight and object::Lighting = FAIL then
      // if there is a light and Lighting ius not set explicitly,
      // we set it to Explicit
      object::Lighting := Explicit;
    end_if:

    // semantically check for validity
    dom::checkObject(object);
    
    // CameraDirection is handled AFTER checkObject, because
    // otherwise we have problems with the hint set in Piechart3d
    if object::CameraDirectionX <> FAIL or
      object::CameraDirectionY <> FAIL or
      object::CameraDirectionZ <> FAIL then
      // delete those attributes and create an implicit View3d
      viewAttr := null();
      if object::CameraDirectionX <> FAIL then
        viewAttr := viewAttr,
                    ViewPositionX = (float@plot::ExprAttribute::getExpr)(object::CameraDirectionX);
        delete object::CameraDirectionX;
      end_if;
      if object::CameraDirectionY <> FAIL then
        viewAttr := viewAttr,
                    ViewPositionY = (float@plot::ExprAttribute::getExpr)(object::CameraDirectionY);
        delete object::CameraDirectionY;
      end_if;
      if object::CameraDirectionZ <> FAIL then
        viewAttr := viewAttr,
                    ViewPositionZ = (float@plot::ExprAttribute::getExpr)(object::CameraDirectionZ);
        delete object::CameraDirectionZ;
      end_if;
      object::children := [plot::View3d(viewAttr)].object::children
    else
/*---------------------------------------------------------------
      // the following ViewPosition has the same semantics as
      // CameraDirection:it is just the direction of the ray
      // along which the automatic camera is placed (at an 
      // infinite distance with an infinitesimal OpeningAngle)
      viewAttr := ViewPositionX =  -9.3,  // must be a float
                  ViewPositionY = -14.6,  // must be a float
                  ViewPositionZ =   5.9;  // must be a float
      object::children := [plot::View3d(viewAttr)].object::children
---------------------------------------------------------------*/
    end_if;
    
    object
  end_proc:
