//      

/* -----------------------------------------------------------
    SpotLight -- The graphical primitive for a spot light

    Syntax:
    SpotLight(position, target, spotAngle<, lightIntensity><, op1, op2, ...>)

    position, target          : lists of 3 expressions
    spotAngle, lightIntensity : expressions
    op1, op2, ...             : options of the form 'option = value'

    Example:
    >> plot::SpotLight([1, 2, 3], [4, 5, 6], PI/3, 5)

    >> plot::SpotLight([1, 2, 3], [4, 5, 6], PI/3, 5,
                    OrthogonalProjection = TRUE)
----------------------------------------------------------------*/ 

plot::createPlotDomain("SpotLight",
                       "primitive for spot lights"):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::SpotLight::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() then
      if not contains({0, 3, 4}, nops(other)) then
        error("expecting 2 lists and 2 expressions")
      end_if;

      if nops(other) > 0 then
        if not testtype(other[1],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 1st argument")
        end_if;
      
        if not testtype(other[2],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 2nd argument")
        end_if;
        
        if not testtype(other[3], Type::Arithmetical) then
          error("expecting an expressions as 3rd argument")
        end_if;
      
        if nops(other) = 4 then
          if not testtype(other[4], Type::Arithmetical) then
            error("expecting an expressions as 4th argument")
          end_if;
        end_if;
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::Position       := other[1];
      object::Target         := other[2];
      object::SpotAngle      := other[3];
    end_if;
    if nops(other) = 4 then
      object::LightIntensity := other[4];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::SpotLight::print :=
  obj -> hold(plot::SpotLight)(obj::Position, obj::Target, obj::SpotAngle,
                                dom::printAttributes(obj, {Position, Target, SpotAngle})):

plot::SpotLight::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writeSpotLight(attrib, table(), float(attrib[PositionX]),
                                          float(attrib[PositionY]),
                                          float(attrib[PositionZ]),
                                          float(attrib[TargetX]),
                                          float(attrib[TargetY]),
                                          float(attrib[TargetZ]),
                                          float(attrib[SpotAngle]),
                                          float(attrib[LightIntensity]));
  end_proc:
