//      

/* -----------------------------------------------------------
    Transform3d -- generic 3D transformation

    Syntax:
    Transform3d(<shift,> matrix<, op1, op2, ...>)

    shift        : shift vector -  a matrix, an array, 
                   or list with 3 components
                   Default: [0, 0, 0]
    matrix       : the transformation matrix - a matrix, an array, 
                   a list of lists (sublists are rows), or a list 
                   with 9 components
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 
plot::createPlotDomain("Transform3d", "generic 3D transformation"):
// ----------------------------------------------------
plot::Transform3d::styleSheet:= table(Shift = [0, 0, 0]):
// ----------------------------------------------------
// methods yet to be implemented:  convert, convert_to, expr
// ----------------------------------------------------
plot::Transform3d::changeNotifier := proc(object, eq)
local attributename, b, A;
begin
    attributename:= op(eq, 1);
    if attributename = "Shift" then
       b:= op(eq, 2):
       if b::dom::hasProp(Cat::Matrix) = TRUE then
          b:= expr(b);
       end_if:
       if domtype(b) = DOM_ARRAY then
          b:= [op(b)];
       end_if:
       if testargs() and
          not testtype(b, Type::ListOf(Type::Arithmetical, 3, 3)) then
           return("expecting a matrix, an array, or a list of 3 expressions ".
                  "for the shift vector");
       end_if:
       object::dom::extslot(object,"Shift", map(b, float));
       return(FALSE):
    end_if;
    if attributename = "Matrix3d" then
       A:= op(eq, 2):
       if A::dom::hasProp(Cat::Matrix) = TRUE then
          A:= expr(A);
       end_if:
       if domtype(A) = DOM_ARRAY then
          A:= [op(A)];
       end_if:
       if domtype(A) = DOM_LIST and
          nops(A) > 1 and
          domtype(A[1]) = DOM_LIST then
          A:= map(A, op); // allow nested lists
       end_if:
       if testargs() then
         if not testtype(A, Type::ListOf(Type::Arithmetical, 9, 9)) then
            return("expecting a 3 x 3 matrix, a 3 x 3 array, a list of 3 lists, ".
                   "or a list of 9 expressions ".
                   "for the transformation matrix");
         end_if;
       end_if:
       object::dom::extslot(object, "Matrix3d", map(A, float));
       return(FALSE):
    end_if;
    // all other attributes to be handled by extslot
    return(TRUE);
end_proc:
// ----------------------------------------------------
plot::Transform3d::new:=
  proc()
    local object, other, children, dimensions, b, A, res;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) <> 0 then 
       case nops(other)
       of 1 do // other[1] must be the matrix
               b:= [0, 0, 0];
               A:= other[1];
               break;
       of 2 do b:= other[1];
               A:= other[2];
               break;
       otherwise
         error("unexpected argument: ".expr2text(other[3]));
       end_case;
       if testargs() then
          children := object::children;
          if nops(children) <> 0 then
               dimensions := map({op(children)}, x -> x::dom::dimension);
               if nops(dimensions) <> 1 or dimensions <> {3} then
                 error("only 3-dimensional plot objects allowed")
               end_if;
            end_if;
       end_if;
       // do the assignment as a side effect of calling changeNotifier
       res := object::dom::changeNotifier(object, "Shift" = b);
       if domtype(res) = DOM_STRING then
          error(res);
       end_if;
       res := object::dom::changeNotifier(object, "Matrix3d" = A);
       if domtype(res) = DOM_STRING then
          error(res);
       end_if;
    end_if; // if nops(other) <> 0

    // semantically check for validity
    dom::checkObject(object);
end_proc:
// ----------------------------------------------------
plot::Transform3d::print :=
  obj -> hold(plot::Transform3d)(obj::Shift, obj::Matrix3d, op(obj::children),
                                 dom::printAttributes(obj, {Shift, Matrix3d})):
