//      

/* -----------------------------------------------------------
    Translate2d -- 2D translation

    Syntax:
    Translate2d(shift<, op1, op2, ...>)

    shift        : shift vector - list with 2 components
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Translate2d", "2D translation"):

// methods yet to be implemented:  convert, convert_to, expr

plot::Translate2d::styleSheet := table(Matrix2d = [1,0,0,1]):

plot::Translate2d::hiddenSlots({Matrix2d}):


// here we have to do something
plot::Translate2d::new:=
  proc()
    local object, other, children, dimensions;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if not contains({0,1}, nops(other)) then
      error("unexpected arguments: ".expr2text(other[2]));
    end_if;

    if testargs() and nops(other) = 1 then 
      if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
        other[1]:= [op(other[1])];
      end_if;
      if not testtype(other[1],
                      Type::ListOf(Type::Arithmetical, 2, 2)) then
        error("expecting a list of 2 expressions");
      end_if;
    end_if;

    if nops(other) = 1 then 
      object::Shift := other[1];
    end_if;

    children := object::children;
    if nops(children) = 0 then
      // empty Translate2d
      return(dom::checkObject(object))
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {2} then
      error("only 2-dimensional plot objects allowed")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Translate2d::print :=
  obj -> hold(plot::Translate2d)(obj::Shift, op(obj::children),
                                 dom::printAttributes(obj, {Shift})):

