//      

/* -----------------------------------------------------------
    Translate3d -- 3D translation

    Syntax:
    Translate3d(shift<, op1, op2, ...>)

    shift        : shift vector - list with 3 components
    op1, op2, ...: plot options of the form 'option = value'
----------------------------------------------------------------*/ 

plot::createPlotDomain("Translate3d", "3D translation"):

// methods yet to be implemented:  convert, convert_to, expr

plot::Translate3d::styleSheet := table(Matrix3d = [1,0,0,
                                                   0,1,0,
                                                   0,0,1]):

plot::Translate3d::hiddenSlots({Matrix3d}):

// here we have to do something
plot::Translate3d::new:=
  proc()
    local object, other, children, dimensions;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if not contains({0,1}, nops(other)) then
      error("unexpected arguments: ".expr2text(other[2]));
    end_if;

    if testargs() and nops(other) = 1 then 
      if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
        other[1]:= [op(other[1])];
      end_if;
      if not testtype(other[1],
                      Type::ListOf(Type::Arithmetical, 3, 3)) then
        error("expecting a list of 3 expressions");
      end_if;
    end_if;

    if nops(other) = 1 then 
      object::Shift := other[1];
    end_if;

    children := object::children;
    if nops(children) = 0 then
      // empty Translate2d
      return(dom::checkObject(object))
    end_if;
    
    dimensions := map({op(children)}, x -> x::dom::dimension);
    if nops(dimensions) <> 1 or dimensions <> {3} then
      error("only 3-dimensional plot objects allowed")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Translate3d::print :=
  obj -> hold(plot::Translate3d)(obj::Shift, op(obj::children),
                                 dom::printAttributes(obj, {Shift})):
