//      

/* -----------------------------------------------------------
    Arrow2d -- The graphical primitive for 2D arrows

    Syntax:
    Arrow2d(From, To<, op1, op2, ...>)

    From, To              : lists of 2 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Arrow2d([1, 2], [4, 5])

    >> plot::Arrow2d([1, 2], [4, 5], TipAngle = PI/4)

    >> plot::Arrow2d(matrix([[1,4],[2, 5]])) 

    >> plot::Arrow2d([4, 5])          // ==> To=[0,0]

    >> plot::Arrow2d(matrix([4, 5]))  // ==> To=[0,0]

----------------------------------------------------------------*/ 

plot::createPlotDomain("Arrow2d",
                       "graphical primitive for 2D arrows"):

//-----------------------------------------------------------------------------
plot::Arrow2d::styleSheet:= table(
      FromX  = 0,
      FromY  = 0,
      ToX    = 1,
      ToY    = 0
):

// methods yet to be implemented:  convert, convert_to, expr

//-----------------------------------------------------------------------------
plot::Arrow2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() then
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3])):
      end_if;

      if nops(other) > 0 then
        if not testtype(other[1],
                        Type::ListOf(Type::Arithmetical, 2, 2)) and
          not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 2 expressions as 1st argument")
        end_if;
      end_if;
      
      if nops(other) = 2 then
        if not testtype(other[2],
                        Type::ListOf(Type::Arithmetical, 2, 2)) and
          not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 2 expressions as 2nd argument")
        end_if;
      end_if;
    end_if;
    
    if   nops(other) = 1 then
      object::To   := other[1];
    elif nops(other) = 2 then
      object::From := other[1];
      object::To   := other[2];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Arrow2d::print :=
  obj -> hold(plot::Arrow2d)(obj::From, obj::To):

plot::Arrow2d::doPlotStatic :=
  proc(out, obj, attrib, inherited)
  begin
    if map({attrib[FromX], attrib[FromY], attrib[ToX], attrib[ToY]},
           domtype@float) = {DOM_FLOAT} then
      return(out::writeArrow2d(attrib, table(),
        float(attrib[FromX]), float(attrib[FromY]),
        float(attrib[ToX]), float(attrib[ToY])));
    else
      return();
    end_if;
  end_proc:
