//      

/* -----------------------------------------------------------
    Arrow3d -- The graphical primitive for 3D arrows

    Syntax:
    Arrow3d(From, To<, op1, op2, ...>)

    From, To              : lists of 3 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Arrow3d([1, 2, 3], [4, 5, 6])

    >> plot::Arrow3d([1, 2, 3], [4, 5, 6], TipAngle = PI/3)

    >> plot::Arrow3d(matrix([[1,4],[2, 5],[3,6]]))

    >> plot::Arrow3d([4, 5, 6])          // ==> To=[0,0]

    >> plot::Arrow3d(matrix([4, 5, 6]))  // ==> To=[0,0]
----------------------------------------------------------------*/ 

plot::createPlotDomain("Arrow3d",
                       "graphical primitive for 3D arrows"):

//-----------------------------------------------------------------------------
plot::Arrow3d::styleSheet:= table(
      FromX  = 0,
      FromY  = 0,
      FromZ  = 0,
      ToX    = 1,
      ToY    = 0,
      ToZ    = 0,
      LineColorDirectionY=0
):

// methods yet to be implemented:  convert, convert_to, expr

//-----------------------------------------------------------------------------
plot::Arrow3d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if testargs() then
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3])):
      end_if;

      if nops(other) > 0 then
        if not testtype(other[1],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
          not (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 1st argument")
        end_if;
      end_if;
        
      if nops(other) = 2 then
        if not testtype(other[2],
                        Type::ListOf(Type::Arithmetical, 3, 3)) and
          not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
          error("expecting a list of 3 expressions as 2nd argument")
        end_if;
      end_if;
    end_if;

    if   nops(other) = 1 then
      object::To   := other[1];
    elif nops(other) = 2 then
      object::From := other[1];
      object::To   := other[2];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Arrow3d::print :=
  obj -> hold(plot::Arrow3d)(obj::From, obj::To):

plot::Arrow3d::doPlotStatic :=
  proc(out, obj, attrib, inherited)
  begin
    if map({attrib[FromX], attrib[FromY], attrib[FromZ],
            attrib[ToX], attrib[ToY], attrib[ToZ]}, domtype@float) =
       {DOM_FLOAT} then
      return(out::writeArrow3d(attrib, table(),
        float(attrib[FromX]), float(attrib[FromY]), float(attrib[FromZ]),
        float(attrib[ToX]), float(attrib[ToY]), float(attrib[ToZ])));
    else
      return();
    end_if;
  end_proc:
