//      

/* -----------------------------------------------------------
    Circle2d -- The graphical primitive for 2D circles

    Syntax:
    Circle2d(radius<, center><, op1, op2, ...>)

    radius                : expression
    center                : list of 2 expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::Circle2d(2)

    >> plot::Circle2d(2, [1, 2])
----------------------------------------------------------------*/ 

plot::createPlotDomain("Circle2d",
                       "graphical primitive for 2D circles"):

//---------------------------------------------------------
plot::Circle2d::styleSheet := table(
      Radius  = 1,
      CenterX = 0,
      CenterY = 0,
      Filled  = FALSE
):

plot::Circle2d::setPrimaryColor(LineColor):
//------------------------------------------------------------------------
// Hints for parents:
plot::Circle2d::hints := {Scaling = Constrained}:
//---------------------------------------------------------
// methods yet to be implemented:  convert, convert_to, expr
//---------------------------------------------------------
plot::Circle2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;

    if testargs() then
      if nops(other) >= 1 and not testtype(other[1], Type::Arithmetical) then
        error("1st argument: expecting an expression (the radius)")
      end_if;
      if nops(other) >= 2 and not testtype(other[2],
                      Type::ListOf(Type::Arithmetical, 2, 2)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("2nd argument: expecting a list of 2 expressions (the center)")
      end_if;
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3]))
      end_if;
    end_if;
    
    if nops(other) <> 0 then
      object::Radius := other[1];
      if nops(other) = 2 then
        object::Center := other[2];
      end_if;
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

//---------------------------------------------------------
plot::Circle2d::print :=
  obj -> hold(plot::Circle2d)(obj::Radius, obj::Center):

//---------------------------------------------------------
plot::Circle2d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    return(out::writeArc2d(attrib, table(),
      float(attrib[CenterX]), float(attrib[CenterY]), float(attrib[Radius])$ 2));
  end_proc:
