// 

plot::createPlotDomain("Conformal",
		       "graphical primitive for conformal plots",
		       2,
		       [Function,
			ZName, ZMin, ZMax, ZRange,
			XMesh, YMesh, Mesh, 
			XSubmesh, YSubmesh, Submesh,
			PointsVisible, 
                        PointSize,
                        AdaptiveMesh,
                        LinesVisible,
                        LineStyle, 
                        LineWidth, AntiAliased,
			LineColor, Color, LineColor2, 
                        LineColorType,
                        LineColorFunction,
                        LineColorDirection, 
                        LineColorDirectionX, 
                        LineColorDirectionY
                       ]):

plot::Conformal::styleSheet := table(LegendEntry = TRUE,
                                     XMesh = 11, YMesh = 11):

plot::Conformal::new :=
  proc()
    local object, other;
  begin
    object := dom::checkArgs(["Z"], args());
    
    other := object::other;
    
    if nops(other) > 1 then
      error("unexpected argument ".expr2text(other[2]));
    end_if;
    if nops(other) > 0 then
      object::Function := other[1];
    end_if;
    
    dom::checkObject(object);
  end_proc:
  
plot::Conformal::print :=
  proc(c)
  begin
    hold(plot::Conformal)(c::Function, c::ZName = c::ZRange)
  end_proc:

plot::Conformal::doPlotStatic :=
  proc(out, c: plot::Conformal, attributes, inheritedAttributes)
    local ziv, z, i, xmin, xmax, ymin, ymax, cleaned_attribs,
	  f, umesh, vmesh, vbox, 
          linecolorfunction1, linecolorfunction2;
  begin
    cleaned_attribs := 
    out::fixAttributes(attributes, plot::Curve2d);
    
    z := attributes[ZName];
    ziv := hull(attributes[ZMin], attributes[ZMax]);
    [xmin, xmax] := [op(Re(ziv))];
    [ymin, ymax] := [op(Im(ziv))];
    f := subs(c::Function, attributes[ParameterName]=attributes[ParameterValue], Unsimplified);
    f := fp::unapply(f, z);
    umesh := attributes[XMesh] - 1;
    vmesh := attributes[YMesh] - 1;

    // set linecolorfunction1 for the curves parametrized by Re(z):
    // set linecolorfunction2 for the curves parametrized by Im(z):
    if contains(attributes, LineColorFunction) then
       linecolorfunction1:= subs(((u, x, y /*, animationparameter*/)
                                   -> `#lcf`(u + `#shift(u)`, x, y, 1, args(3..args(0)))),
                                 [`#lcf` = attributes[LineColorFunction],
                                  `#shift(u)` = ((vmesh-`#i`)/vmesh*ymin + `#i`/vmesh*ymax)*I]);
       linecolorfunction2:= subs(((u, x, y /*, animationparameter*/)
                                   -> `#lcf`(`#shift(u)` + u*I, x, y, 2, args(3..args(0)))),
                                 [`#lcf` = attributes[LineColorFunction],
                                  `#shift(u)` = (umesh-`#i`)/umesh*xmin+ `#i`/umesh*xmax]);
    else  // RGB colors to be used as constant functions
       linecolorfunction1:= attributes[LineColor];  
       linecolorfunction2:= attributes[LineColor2]; 
    end_if;
    
    vbox := {};
    
// if attributes[XLinesVisible] <> FALSE then // the renderer reserves XLinesVisible
                                              // for 3D surface objects
    for i from 0 to umesh do
      vbox := vbox union
	     {out(plot::Curve2d([Re::lazy, Im::lazy]
					   (f((umesh-i)/umesh*xmin+
					      i/umesh*xmax+
					      z*I)),
					   z=ymin..ymax,
					   op(cleaned_attribs),
					   UMesh=attributes[YMesh],
					   USubmesh=attributes[YSubmesh],
                                           LineColorFunction=subs(linecolorfunction2,`#i`=i)
					  ),
			     inheritedAttributes, Raw)};
    end_for;
// end_if;
    
// if attributes[VLinesVisible] <> FALSE then // the renderer reserves YLinesVisible
                                              // for 3D surface objects
    for i from 0 to vmesh do
      vbox := vbox union
	     {out(plot::Curve2d([Re::lazy, Im::lazy]
					   (f(z + 
					      ((vmesh-i)/vmesh*ymin+
					       i/vmesh*ymax)*I)),
					   z=xmin..xmax,
					   op(cleaned_attribs),
					   UMesh=attributes[XMesh],
				           Submesh=attributes[XSubmesh],
                                           LineColorFunction=subs(linecolorfunction1,`#i`=i)
					  ),
			     inheritedAttributes, Raw)};
    end_for;
// end_if;

//    [min(op(map(vbox, op, [1,1])))..max(op(map(vbox, op, [1,2]))),
//     min(op(map(vbox, op, [2,1])))..max(op(map(vbox, op, [2,2])))]
    
    out::commonViewingBox(vbox);
    
  end_proc:
  
