/* -------------------------------------------------------------
Status 23.2.03: Everything should work. The strategy for 
                logarithmic plots still needs to be tested.

-----------------------------------------------------------------
plot::Curve3d -- The graphical primitive for 3D curves

Call(s): Curve3d([x(t), y(t), z(t)], 
                 t = TMin .. TMax
                <a = AMin .. AMax>,
                <Color = c>,
                <Mesh = n>,
                <Submesh = m>,
                <AdaptiveMesh = l>
                <DiscontinuitySearch = TRUE/FALSE>
                <opt1, opt2, ...>)
Parameters:
    x, y, z   : arithmetical expression (depending on t)
                and, possibly, on an animation parameter
    t         : the curve parameter: DOM_IDENT or indexed identifier
    TMin, TMax: numerical real values or univariate expressions
                of the animation  parameter
    a         : the animation parameter: DOM_IDENT or indexed identifier
    AMin, AMax: numerical real values
    c         : an RGB value, an RGBa value or a procedure
    n         : the number of mesh points: an integer > 0
    m         : the number of 'inner mesh points': an integer >= 0

Options:
    opt1, opt2, ... : general 3d plot options

Examples:
 >> plot::Curve3d([t*sin(t), t*cos(t), t], t = 0..2*PI )
 >> plot::Curve3d([sin(t)/t, cos(t)/t, 1/t], t = 0..2*PI, Color = RGB::Blue )
----------------------------------------------------------------*/
plot::createPlotDomain("Curve3d",
                       "graphical primitive for 3D curves"):

// methods yet to be implemented:  convert, convert_to, expr

plot::Curve3d::styleSheet := table(LegendEntry = TRUE, 
                                   UMesh=121,
                                   UMin=-5, UMax=5,
                                   LineColorDirectionY=0):

//----------------------------------------------------------------------
plot::Curve3d::new:= proc()
local object, other, X, Y, Z, xx, i;
begin
    // check all known options from the argument list
    object := dom::checkArgs(["U"], args());
    // get arguments which are not yet processed
    other := object::other;
  
  if nops(other) > 0 and (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
    other[1] := [op(other[1])];
  end_if;

  if nops(other) > 0 and expr2text(domtype(other[1])) = "piecewise" then
    xx := {op(piecewise::expressions(other[1]))};
    if map(xx, domtype) <> {DOM_LIST} or
        map(xx, nops) <> {3} then
      error("expecting each piecewise branch to be a list of three function expressions");
    end_if;
    other[1] := [piecewise::extmap(other[1], op, i) $i=1..3];
  end_if;
  
    if testargs() and nops(other) > 0 then
      if domtype(other[1]) <> DOM_LIST or
        nops(other[1]) <> 3 then
        error("expecting a list of three function expressions");
      end_if;
      if nops(other) > 1 then
        error("unexpected argument: ".expr2text(other[2]));
      end_if;
    end_if;
    
    if nops(other) > 0 then
      [X, Y, Z]:= other[1];
      object::XFunction:= X;
      object::YFunction:= Y;
      object::ZFunction:= Z;
    end_if;
    
    //---------------------------------------
    // Arrgrr: request by the school fraction.
    //---------------------------------------
    if object::UName = FAIL then
       xx:= numeric::indets(object::XFunction) union
            numeric::indets(object::YFunction) union
            numeric::indets(object::ZFunction);
       if nops(xx) = 0 then
           object::UName:= hold(x);
       elif nops(xx) = 1 then
           object::UName:= op(xx);
       else error("cannot figure out the name of the independent variable");
       end_if;
    end_if:
    //---------------------------------------
    // end of Arrgrr
    //---------------------------------------

    // semantically check for validity
    dom::checkObject(object);
end_proc:

//----------------------------------------------------------------------
plot::Curve3d::print :=
  obj -> hold(plot::Curve3d)([obj::XFunction, obj::YFunction, obj::ZFunction],
                             obj::UName=obj::URange):

//----------------------------------------------------------------------
plot::Curve3d::doPlotStatic := proc(out, object, attributes, inheritedAttributes,
                                flag = FALSE)
local mesh, submesh, adaptivemesh, discontinuitysearch,
      X, Y, Z, u, umin, umax, xmin, xmax, ymin, ymax, zmin, zmax,
      colorfunction, viewingbox, singularities, 
      i, branch, branches, clipFactor, clipBranch,
      _min, _max, _range;
begin
    mesh    := attributes[UMesh];
    submesh := attributes[USubmesh];
    u       := attributes[UName];
    umin    := float(attributes[UMin]);
    umax    := float(attributes[UMax]);
    X       := attributes[XFunction];
    Y       := attributes[YFunction];
    Z       := attributes[ZFunction];
    adaptivemesh:= attributes[AdaptiveMesh];
    discontinuitysearch:=
               attributes[DiscontinuitySearch];
    [xmin,xmax,ymin,ymax,zmin,zmax]:= [Automatic $ 6]:
    if contains(attributes, ViewingBoxXMin) then
         xmin:= attributes[ViewingBoxXMin]:
    end_if;
    if contains(attributes, ViewingBoxYMin) then
         ymin:= attributes[ViewingBoxYMin]:
    end_if;
    if contains(attributes, ViewingBoxZMin) then
         zmin:= attributes[ViewingBoxZMin]:
    end_if;
    if contains(attributes, ViewingBoxXMax) then
         xmax:= attributes[ViewingBoxXMax]:
    end_if;
    if contains(attributes, ViewingBoxYMax) then
         ymax:= attributes[ViewingBoxYMax]:
    end_if;
    if contains(attributes, ViewingBoxZMax) then
         zmax:= attributes[ViewingBoxZMax]:
    end_if;
    if contains(attributes, LineColorFunction) then
      colorfunction := attributes[LineColorFunction];
    else colorfunction := () -> null();
    end_if;
    //-------------------------------------------------------------
    // Set the parameters:
    //-------------------------------------------------------------
    [umin, umax, xmin, xmax, ymin, ymax, zmin, zmax]:=
          float([umin, umax, xmin, xmax, ymin, ymax, zmin, zmax]):
    mesh:= 1 + (mesh - 1)*(submesh + 1);
    if mesh <= 1 then
       warning("expecting a number of mesh points >= 2, got: ".
               expr2text(mesh).
               ". Setting the number of mesh points to 2.");
       mesh:= 2:
    end_if:
    //-------------------------------------------------------------
    // Modifications for logarithmic plots
    //  !!! This still needs to be tested !!!
    //-------------------------------------------------------------
/*                             
    if attributes[CoordinateType] in {LogLinLin, LogLogLin, LogLinLog, LogLogLog} then
       if (domtype(xmin) = DOM_FLOAT and xmin <= 0) then
          error("expecting a positive X range for a logarithmic X axis. ".
                "Got Xmin = ".expr2text(xmin));
       end_if:
       if (domtype(xmax) = DOM_FLOAT and xmax <= 0) then
          error("expecting a positive X range for a logarithmic X axis. ".
                "Got Xmax = ".expr2text(xmax));
       end_if:
       if xmin <> Automatic then
          xmin:= ln(xmin);
       end_if;
       if xmax <> Automatic then
          xmax:= ln(xmax);
       end_if;
       X:= ln@X:
    end_if;
    if attributes[CoordinateType] in {LinLogLin, LogLogLin, LinLogLog, LogLogLog} then
       if (domtype(ymin) = DOM_FLOAT and ymin <= 0) then
          error("expecting a positive Y range for a logarithmic Y axis. ".
                "Got Ymin = ".expr2text(ymin));
       end_if:
       if (domtype(ymax) = DOM_FLOAT and ymax <= 0) then
          error("expecting a positive Y range for a logarithmic Y axis. ".
                "Got Ymax = ".expr2text(ymax));
       end_if:
       if ymin <> Automatic then
          ymin:= ln(ymin);
       end_if;
       if ymax <> Automatic then
          ymax:= ln(ymax);
       end_if;
       Y:= ln@Y;
    end_if;
    if attributes[CoordinateType] in {LinLinLog, LogLinLog, LinLogLog, LogLogLog} then
       if (domtype(zmin) = DOM_FLOAT and zmin <= 0) then
          error("expecting a positive Z range for a logarithmic Z axis. ".
                "Got Zmin = ".expr2text(zmin));
       end_if:
       if (domtype(zmax) = DOM_FLOAT and zmax <= 0) then
          error("expecting a positive Z range for a logarithmic Z axis. ".
                "Got Zmax = ".expr2text(zmax));
       end_if:
       if zmin <> Automatic then
          zmin:= ln(zmin);
       end_if;
       if zmax <> Automatic then
          zmax:= ln(zmax);
       end_if;
       Z:= ln@Z;
    end_if;
*/
    //-------------------------------------------------------------
    // call the plot::curveEval utility
    //-------------------------------------------------------------
    [viewingbox, branches, singularities]:=
            plot::curveEval([X, Y, Z], u = umin .. umax, 
                            [Automatic, Automatic, Automatic], mesh,
                            AdaptiveMesh = adaptivemesh,
                            DiscontinuitySearch = discontinuitysearch):
    //-------------------------------------------------------------
    // We need to undo the logarithmic modifications
    // before writing the data to the XML file.
    //  !!! This still needs to be tested !!!
    //-------------------------------------------------------------
/*
    if attributes[CoordinateType] in {LogLinLin, LogLogLin, LogLinLog, LogLogLog} then
       // x -> exp(x)
       if viewingbox <> NIL then
          viewingbox:= [map(viewingbox[1], exp), viewingbox[2], viewingbox[3]];
       end_if;
       branches:= map(branches, map, pt -> [pt[1], exp(pt[2]), pt[3], pt[4]]);
    end_if;
    if attributes[CoordinateType] in {LinLogLin, LogLogLin, LinLogLog, LogLogLog} then
       // y -> exp(y)
       if viewingbox <> NIL then
          viewingbox:= [viewingbox[1], map(viewingbox[2], exp), viewingbox[3]];
       end_if;
       branches:= map(branches, map, pt -> [pt[1], pt[2], exp(pt[3]), pt[4]]);
    end_if;
    if attributes[CoordinateType] in {LinLinLog, LogLinLog, LinLogLog, LogLogLog} then
       // z -> exp(z)
       if viewingbox <> NIL then
          viewingbox:= [viewingbox[1], viewingbox[2], map(viewingbox[3], exp)];
       end_if;
       branches:= map(branches, map, pt -> [pt[1], pt[2], pt[3], exp(pt[4])]);
    end_if;
*/
    // ------------------------------------------------------------
    // Special: clip out points that are really far away.
    // This seems necessary for Windoof, where plotting
    // raises an error if there are points way out of the
    // viewing area (even if they are clipped).
    // ------------------------------------------------------------
    if viewingbox <> NIL then 
      clipFactor:= 1000:
      // clipBranch:= (t, i) -> (_min < t[i] and t[i] < _max);
      clipBranch:= proc(t, i) begin
                     if t[i] < _min then t[i]:= _min; end_if;
                     if t[i] > _max then t[i]:= _max; end_if;
                     t;
                   end_proc:
      for i from 1 to 3 do // i = 1 = x, i = 2 = y, i = 3 = z
        _min:= op(viewingbox, [i, 1]);
        _max:= op(viewingbox, [i, 2]);
        _range:= _max - _min;
        if iszero(_range) then 
          _range:= _plus(op(viewingbox, [i, 2]) - op(viewingbox, [i, 1]) $ i=1..3);
           if iszero(_range) then 
              _range:= 1;
           end_if;
        end_if;
        _min:= _min - clipFactor*_range;
        _max:= _max + clipFactor*_range;
        branches:= map(branches, /*select*/ map, clipBranch, i+1);
      end_for:
    end_if:
    //-----------------------------------------
    // When Hatch calls:
    //-----------------------------------------
    if flag = TRUE then // The method was called by the Hatch object.
       // It does not need the viewingbox, but the graphical data.
       // The singularities returned by plot::curveEval is a set
       // {u1, u2, ...} of u-values of the singularities of the curve.
       return([branches, singularities])
    end_if;
    //-----------------------------------------
    // write the graphical data to the XML file
    //-----------------------------------------
    for branch in branches do
      out::writePoly3d(attributes, table(), branch, colorfunction, 2..4);
    end_for: // for branch in branches
    //-------------------------------------------------------------
    // Finally, return the viewing box
    //-------------------------------------------------------------
    if viewingbox = NIL then
         return();
    end_if;
    return(viewingbox);
end_proc:
