/* -----------------------------------------------------------
Status 24.2.03: 
   - Es werden im nicht-adaptiven Fall keine Normalen berechnet

plot::Function3d -- The graphical primitive for 2D function plots

Call(s): Function3d(f(x, y), 
                   <x = xmin .. xmax> ,
                   <y = ymin .. ymax> ,
                   <a = amin .. amax>,
                   <Color = c>,
                   <Mesh = [nx, ny]>,
                   <Submesh = [mx, my]>,
                   <AdaptiveMesh = l>
                   <DiscontinuitySearch = TRUE/FALSE>
                   <opt1, opt2, ...>)
Parameters:
    f(x)      : the function: arithmetical expression (depending on x)
                and, possibly, on an animation parameter
    x, y      : the variables of the function: DOM_IDENTs or indexed identifiers
    xmin, xmax: numerical real values or univariate expressions
    ymin, ymax:      of the animation  parameter. Default -5, 5
    a         : the animation parameter: DOM_IDENT or indexed identifier
    amin, amax: numerical real values
    c         : an RGB value, an RGBa value or a procedure
    nx,ny     : the number of mesh points: integers > 0
    mx,my     : the number of 'inner mesh points': integers >= 0
    l         : the number of recursive refinements in the
                adaptive mode: an integer >= 0

Options:
    opt1, opt2, ... : general 3d plot options

Examples:
 >> plot::Function3d(sin(x^2 + y^2), x=0..2*PI, y=0..2*PI)
 >> plot::Function3d(sin(x^2 + y^2), x=0..2*PI, y=0..2*PI, Color = RGB::Blue )
----------------------------------------------------------------------*/
plot::createPlotDomain("Function3d",
                  "graphical primitive for 3D function graphs"):

plot::Function3d::styleSheet:=
  table(
        // XLinesVisible = TRUE; // 'global' default
        // YLinesVisible = TRUE; // 'global' default
        LegendEntry = TRUE,
        MeshVisible = FALSE,
        LineColor = RGB::Black.[0.25], // 'global' default is RGB::Red
        XMesh=25, YMesh=25,
        XMin=-5,  XMax=5,
        YMin=-5,  YMax=5,
        LineColorDirectionY=0):

plot::Function3d::hints := {XAxisTitle, YAxisTitle, ZAxisTitle}:

plot::Function3d::setHint:= proc(object)
  begin
    if object::XName <> FAIL and
       object::XAxisTitel = FAIL then
       plot::setHint(object, XAxisTitle = expr2text(object::XName)):
    end_if:
    if object::YName <> FAIL and
       object::YAxisTitel = FAIL  then
       plot::setHint(object, YAxisTitle = expr2text(object::YName)):
    end_if;
    if object::ZName <> FAIL and
       object::ZAxisTitle = FAIL  then
       plot::setHint(object, ZAxisTitle = expr2text(object::ZName)):
    end_if;
end_proc:


//--------------------------------------------------------------------
plot::Function3d::new:= proc()
local object, other, xy;
begin
    object := dom::checkArgs(["X", "Y"], args());

    // For Function3d, object::other is just the list [f(x, y)]
    other := object::other;

    if nops(other) > 1 then
      error("unexpected argument: ".expr2text(other[2]));
    end_if;

    if nops(other) > 0 then
      object::Function:= other[1];
    end_if;

    //----------------------------------------------------------
    // Arrgrr: request by the school fraction.
    //----------------------------------------------------------
    if object::XName = FAIL or object::YName = FAIL then
       xy:= numeric::indets(object::Function);
       if object::XName = FAIL and object::YName <> FAIL then
          xy:= xy minus {object::YName};
          if nops(xy)= 0 then
               object::XName:= hold(x);
          elif nops(xy) = 1 then
               object::XName:= op(xy)
          else error("cannot figure out the name of the 1st independent variable");
          end_if;
       elif object::XName <> FAIL and object::YName = FAIL then
          xy:= xy minus {object::XName};
          if nops(xy)= 0 then
               if object::XName = hold(y) then
                  object::YName:= hold(Y);
               else               
                  object::YName:= hold(y);
               end_if;
          elif nops(xy) = 1 then
               object::YName:= op(xy)
          else error("cannot figure out the name of the 2nd independent variable");
          end_if;
      elif object::XName = FAIL and object::YName = FAIL then
          if nops(xy)= 0 then
               object::XName:= hold(x);
               object::YName:= hold(y);
          elif nops(xy)= 1 then
               object::XName:= op(xy);
               if object::XName = hold(y) then
                  object::YName:= hold(Y);
               else               
                  object::YName:= hold(y);
               end_if;
          elif nops(xy) = 2 then
               object::XName:= xy[1];
               object::YName:= xy[2];
          else error("cannot figure out the names of the independent variables");
          end_if;
       end_if;
    end_if:
    //----------------------------------------------------------
    // end of Arrgrr
    //----------------------------------------------------------

    dom::setHint(object);
    dom::checkObject(object);
end_proc:

//--------------------------------------------------------------------
//--------------------------------------------------------------------
plot::Function3d::print :=
  obj -> hold(plot::Function3d)(obj::Function,
                                obj::XName=obj::XRange,
                                obj::YName=obj::YRange):

//--------------------------------------------------------------------
// generic routine for plotting a non-animated object or a single frame of an animated one.
//--------------------------------------------------------------------
plot::Function3d::doPlotStatic:=
proc(out, object, attributes, inheritedAttributes)
// out:        output object, providing the specifics for MuPlotML, POV, etc.
// object:     the object that was created by the new method above.
//             Usually, we do not need it here.
// attributes: a table of all attributes (inherited attributes as well as
//             those created from the mandatory parameters in the new method).
//             Zusaetzlich sind enthalten:
//             attributes[TimeValue] (float)
//             attributes[ParameterValue] (float)
//             However, hints are not included in 'attributes'.
// inheritedAttributes: 
//             the MuPlotML will be called with 3 arguments.
//             However, you do no need to process the 3rd
//             argument 'inheritedAttributes': just ignore it.
local fX, fY, fZ,
      x, xmin, xmax, xmesh, xsubmesh,
      y, ymin, ymax, ymesh, ysubmesh,
      adaptivemesh,
      fillcolortype, fillcolorfunction,
      linecolortype, linecolorfunction, haslinecolorfunction,
      vbxmin, vbxmax, 
      vbymin, vbymax, 
      vbzmin, vbzmax, 
      viewingbox, data, i, xlines, ylines, line,
      _min, _max, _range, clipFactor, clipBranch;
begin
    fX    := (u, v) -> u:
    fY    := (u, v) -> v:
    fZ    :=        attributes[Function]; // a procedure
    x    :=        attributes[XName]:
    xmin :=        attributes[XMin]:
    xmax :=        attributes[XMax]:
    xmesh:=        attributes[XMesh];
    xsubmesh:=     attributes[XSubmesh];
    y    :=        attributes[YName]:
    ymin :=        attributes[YMin]:
    ymax :=        attributes[YMax]:
    ymesh:=        attributes[YMesh];
    ysubmesh:=     attributes[YSubmesh];
    adaptivemesh:= attributes[AdaptiveMesh];
    fillcolortype:=attributes[FillColorType]; // either Flat, Monochrome(=Height),
                                              // Dichromatic, Rainbow or Functional.
    linecolortype:=attributes[LineColorType]; // either Flat, Monochrome(=Height),
                                              // Dichromatic, Rainbow or Functional.
    // If one of the color types above is Functional, we need to compute
    // and write color values. Otherwise, no action is required here.
    [vbxmin,vbxmax,vbymin,vbymax,vbzmin,vbzmax]:= [xmin, xmax, ymin, ymax, Automatic $ 2]:
    if contains(attributes, ViewingBoxXMin) then vbxmin := attributes[ViewingBoxXMin]: end_if;
    if contains(attributes, ViewingBoxXMax) then vbxmax := attributes[ViewingBoxXMax]: end_if;
    if contains(attributes, ViewingBoxYMin) then vbymin := attributes[ViewingBoxYMin]: end_if;
    if contains(attributes, ViewingBoxYMax) then vbymax := attributes[ViewingBoxYMax]: end_if;
    if contains(attributes, ViewingBoxZMin) then vbzmin := attributes[ViewingBoxZMin]: end_if;
    if contains(attributes, ViewingBoxZMax) then vbzmax := attributes[ViewingBoxZMax]: end_if;
    if contains(attributes, FillColorFunction) then 
      fillcolorfunction:= float@(attributes[FillColorFunction]); // a procedure
    else fillcolorfunction:= () -> null();
    end_if;
    if contains(attributes, LineColorFunction) then 
      linecolorfunction:= float@(attributes[LineColorFunction]); // a procedure
      haslinecolorfunction:= TRUE;
    else linecolorfunction:= () -> null();
         haslinecolorfunction:= FALSE;
    end_if;
    //-------------------------------------------------------------
    // Now, let the library compute the graphical data:
    //-------------------------------------------------------------
    // Set the parameters:
    //-------------------------------------------------------------
    [xmin, xmax, ymin, ymax]:= float([xmin, xmax, ymin, ymax]);
    [vbxmin, vbxmax, vbymin, vbymax, vbzmin, vbzmax]:= 
            float([vbxmin, vbxmax, vbymin, vbymax, vbzmin, vbzmax]);
    //-------------------------------------------------------------
    // Modifications for logarithmic plots
    //  !!! This still needs to be tested !!!
    //-------------------------------------------------------------
/*                             
    if attributes[CoordinateType] in
       {LogLinLin, LogLogLin, LogLinLog, LogLogLog} then
       if xmin <= 0 then
          error("expecting a positive X range for a logarithmic X axis. ".
                "Got Xmin = ".expr2text(xmin));
       end_if:
       if xmax <= 0 then
          error("expecting a positive X range for a logarithmic X axis. ".
                "Got Xmax = ".expr2text(xmax));
       end_if:
       if (domtype(vbxmin) = DOM_FLOAT and vbxmin <= 0) then
          error("expecting a positive X range for the viewing box of a logarithmic X axis. ".
                "Got ViewingBoxXmin = ".expr2text(vbxmin));
       end_if:
       if (domtype(vbxmax) = DOM_FLOAT and vbxmax <= 0) then
          error("expecting a positive X range for the viewing box of a logarithmic X axis. ".
                "Got ViewingBoxXmax = ".expr2text(vbxmax));
       end_if:
       if vbxmin <> Automatic then vbxmin:= ln(vbxmin); end_if:
       if vbxmax <> Automatic then vbxmax:= ln(vbxmax); end_if:
       fX:= ln@fX:
    end_if;
    if attributes[CoordinateType] in
       {LinLogLin, LogLogLin, LinLogLog, LogLogLog} then
       if ymin <= 0 then
          error("expecting a positive Y range for a logarithmic Y axis. ".
                "Got Ymin = ".expr2text(ymin));
       end_if:
       if ymax <= 0 then
          error("expecting a positive Y range for a logarithmic Y axis. ".
                "Got Ymax = ".expr2text(ymax));
       end_if:
       if (domtype(vbymin) = DOM_FLOAT and vbymin <= 0) then
          error("expecting a positive Y range for the viewing box of a logarithmic Y axis. ".
                "Got ViewingBoxYmin = ".expr2text(vbymin));
       end_if:
       if (domtype(vbymax) = DOM_FLOAT and vbymax <= 0) then
          error("expecting a positive Y range for the viewing box of a logarithmic Y axis. ".
                "Got ViewingBoxYmax = ".expr2text(vbymax));
       end_if:
       if vbymin <> Automatic then vbymin:= ln(vbymin); end_if:
       if vbymax <> Automatic then vbymax:= ln(vbymax); end_if:
       fY:= ln@fY;
    end_if;
    if attributes[CoordinateType] in
       {LinLinLog, LogLinLog, LinLogLog, LogLogLog} then
       if (domtype(vbzmin) = DOM_FLOAT and vbzmin <= 0) then
          error("expecting a positive Z range for the viewing box of a logarithmic Z axis. ".
                "Got ViewingBoxZmin = ".expr2text(vbzmin));
       end_if:
       if (domtype(vbzmax) = DOM_FLOAT and vbzmax <= 0) then
          error("expecting a positive Z range for the viewing box of a logarithmic Z axis. ".
                "Got ViewingBoxZmax = ".expr2text(vbzmax));
       end_if:
       if vbzmin <> Automatic then vbzmin:= ln(vbzmin); end_if:
       if vbzmax <> Automatic then vbzmax:= ln(vbzmax); end_if:
       fZ:= ln@fZ;
    end_if;
*/
    //-------------------------------------------------------------
    // call the plot::functionEval utility
    //-------------------------------------------------------------
    data := FAIL;
    if adaptivemesh=0 then
       traperror(([viewingbox, data]:= plot::surfaceEval(
                                  fX, fY, fZ, 
                                  xmesh, xsubmesh, xmin .. xmax,
                                  ymesh, ysubmesh, ymin .. ymax,
                                  vbxmin .. vbxmax, 
                                  vbymin .. vbymax, 
                                  vbzmin .. vbzmax, 
                                  AdaptiveMesh = adaptivemesh
                                 )));
    end_if;
    if data=FAIL then
      [viewingbox, data, xlines, ylines] :=
      plot::adaptiveSurfaceEval(fX, fY, fZ,
                                xmesh, xsubmesh, xmin .. xmax,
                                ymesh, ysubmesh, ymin .. ymax,
                                vbxmin .. vbxmax, 
                                vbymin .. vbymax, 
                                vbzmin .. vbzmax, 
                                AdaptiveMesh = adaptivemesh
                               );
      if adaptivemesh=0 then adaptivemesh := 1; end;
    end_if;
    //-------------------------------------------------------------
    // We need to undo the logarithmic modifications
    // before writing the data to the XML file. 
    //-------------------------------------------------------------
/*
    if attributes[CoordinateType] in
       {LogLinLin, LogLogLin, LogLinLog, LogLogLog} then
       // x -> exp(x)
       if viewingbox <> NIL then
          viewingbox[1]:= map(viewingbox[1], exp);
       end_if;
       data:= map(data, pt -> (pt[3]:= exp(pt[3]);pt)):
    end_if;
    if attributes[CoordinateType] in
       {LinLogLin, LogLogLin, LinLogLog, LogLogLog} then
       // y -> exp(y)
       if viewingbox <> NIL then
          viewingbox[2]:= map(viewingbox[2], exp);
       end_if;
       data:= map(data, pt -> (pt[4]:= exp(pt[4]);pt)):
    end_if;
    if attributes[CoordinateType] in
       {LinLinLog, LogLinLog, LinLogLog, LogLogLog} then
       // z -> exp(z)
       if viewingbox <> NIL then
          viewingbox[3]:= map(viewingbox[3], exp);
       end_if;
       data:= map(data, pt -> (pt[5]:= exp(pt[5]);pt)):
    end_if;
*/
    // ------------------------------------------------------------
    // Special: clip out points that are really far away.
    // This seems necessary for Windoof, where plotting
    // raises an error if there are points way out of the
    // viewing area (even if they are clipped).
    // ------------------------------------------------------------
    if viewingbox <> NIL then
      clipFactor:= 1000:
      clipBranch:= proc(t, i)
                   begin
                     if t[i] < _min then t[i]:= _min; end_if;
                     if t[i] > _max then t[i]:= _max; end_if;
                     t;
                   end_proc:
      for i from 1 to 3 do // i = 1 = x, i = 2 = y, i = 3 = z
        _min:= op(viewingbox, [i, 1]);
        _max:= op(viewingbox, [i, 2]);
        _range:= _max - _min;
        if iszero(_range) then  
          _range:= _plus(op(viewingbox, [i, 2]) - op(viewingbox, [i, 1]) $ i=1..3);
           if iszero(_range) then
              _range:= 1;
           end_if;
        end_if;
        _min:= _min - clipFactor*_range;
        _max:= _max + clipFactor*_range;
        data:= map(data, clipBranch, 2 + i);
      end_for:
    end_if:
    //-----------------------------------------
    // write the graphical data to the XML file
    //-----------------------------------------
    if adaptivemesh = 0 then
      out::writeRectangularMesh(attributes, table(), data,
        linecolorfunction, fillcolorfunction,
        xmesh, ymesh, xsubmesh, ysubmesh, TRUE);
    else // adaptive case
      out::writeTriangles(attributes, table(), data, linecolorfunction, fillcolorfunction);
      //---------------------------------------------------------------------
      // Write XYLines for the adaptive case
      //---------------------------------------------------------------------
      for line in xlines do
        if nops(line) = 0 then next; end_if;
        line := sort([op(line)],
                     (a,b) -> a[2] < b[2]);
        out::writeUVXYLine(attributes, table(), line, linecolorfunction, TRUE, TRUE);
      end_for;
      for line in ylines do
        if nops(line) = 0 then next; end_if;
        line := sort([op(line)],
                     (a,b) -> a[1] < b[1]); 
        out::writeUVXYLine(attributes, table(), line, linecolorfunction, FALSE, TRUE);
      end_for;
    end_if;
      
    //-------------------------------------------------------------
    // write contours if asked for
    //-------------------------------------------------------------
    if attributes[ZContours] <> [] and
       viewingbox <> NIL then
      if adaptivemesh > 0 then
        out::writeMeshContours(attributes, table(), data, 3..5, 5, attributes[ZContours],
                                p -> linecolorfunction(op(p, 3..5)),
                                op(viewingbox, [3, 1]), op(viewingbox, [3, 2]));
      else
        out::writeGridContours(attributes, table(), data,
                                xmesh + (xmesh - 1) * xsubmesh,
                                ymesh + (ymesh - 1) * ysubmesh,
                                3..5, 5, attributes[ZContours],
                                p -> linecolorfunction(op(p, 3..5)),
                                op(viewingbox, [3, 1]), op(viewingbox, [3, 2]));
      end_if;
    end_if;

    //-------------------------------------------------------------
    // Finally, return the viewing box
    //-------------------------------------------------------------
    if viewingbox = NIL then
       return();
    end_if;
    return(viewingbox);
  end_proc:
//-----------------------------------------------------------------
