// 

// plot::HonestFunction2d -- "honest" plot of a 2D function,
//  i.e., an interval enclosure

/*
 
 plot(plot::HonestFunction2d(sin(1/x), x=-1..1));
 
*/
 
/*
 TODO:
 Adaptive mesh
 Clipping
 definition of color functions
 higher order enclosures using derivatives
 discontinuities
 vertical asymptotes?
 logarithmic scaling
 
*/
  
plot::createPlotDomain("HonestFunction2d",
		       "\"honest\" plot of a 2D function",
		       2,
		       [Function,
			LineColorFunction, FillColorFunction,
			XName, XMin, XMax, XRange,
			XMesh, XSubmesh, Mesh, Submesh,
//			DiscontinuitySearch,
			LineColor, LineColor2, LineWidth, LineStyle,
			LinesVisible, LineColorType, AntiAliased,
			LineColorDirectionX, LineColorDirectionY,
			LineColorDirection,
			PointSize, PointStyle, PointsVisible,
			FillColor, FillColor2, FillColorType,
			Filled, FillPattern,
			Color]):
			

plot::HonestFunction2d::styleSheet := table(Filled = TRUE,
					    FillPattern = Solid,
					    FillColorStyle = Flat,
					    PointsVisible = FALSE,
					    LinesVisible = FALSE,
					    XMesh = 121,
//					    DiscontinuitySearch = TRUE,
					    LineColor = RGB::DarkGrey,
					    FillColor = RGB::Blue):
					    
plot::HonestFunction2d::new :=
proc()
  local object, other;
begin
  object := dom::checkArgs(["X"], args());
  other := object::other;
  
  if nops(other) > 0 then
    if nops(other) > 1 then
      error("Unexpected argument ". expr2text(other[2]));
    end_if;
    object::Function := other[1];
  end_if;
  
  dom::checkObject(object);
end_proc:

plot::HonestFunction2d::print :=
obj -> hold(plot::HonestFunction2d)(obj::Function,
				    obj::XName = obj::XRange):
				    
plot::HonestFunction2d::doPlotStatic :=
proc(out, obj, attributes, inherited)
  local x, xminmax, xmin, xmax, xl, xr, branches, mesh,
	submesh, f, ff, ymin, ymax, plotSeg, i;
begin
  x        := attributes[XName];
  xminmax  := hull(attributes[XMin], attributes[XMax])
	    intersect hull(attributes[ViewingBoxXMin],  // don't care if only
			   attributes[ViewingBoxXMax]); // one is set -- zooming sets both
  f := obj::Function;
  if contains(attributes, ParameterName) then
    f := subs(f, attributes[ParameterName]=attributes[hold(ParameterValue)]);
  end_if;
  if not testtype(f, Type::Function) then
    f := fp::unapply(f, x);
  end_if;
  ff := FAIL;
  
  mesh     := attributes[XMesh];
  submesh  := attributes[XSubmesh];
  submesh := 0; // doesn't work properly yet, buggy algorithm!
  if mesh <= 1 then
    warning("expecting a number of mesh points >= 2, got: ".
	    expr2text(mesh).
	    ". Setting the number of mesh points to 2.");
    mesh:= 2:
  end_if:
  
//  if attributes[DiscontinuitySearch] = TRUE then
//    
//  else
  branches := [xminmax];
//  end_if;
  
  ymin := RD_INF;
  ymax := RD_NINF;
  
  plotSeg := proc(xiv)
	       local fx, fxl, fxr, fpxl, fpxr, fpx, fppx,
		     dummy, c1, c2, i, x, xl, xr, xs, polyenc, linenc;
	     begin
	       xs := FAIL;
	       [xl, xr] := [op(xiv)];
	       if submesh > 0 then
		 if ff = FAIL then
		   ff := interval::autodiff(f(x), 2);
		 end_if;
		 [fx, fpx, fppx] := ff(xiv);
		 [fxl, fpxl, dummy] := ff(subsop(xiv, 2=xl));
		 [fxr, fpxr, dummy] := ff(subsop(xiv, 1=xr));
		 
		 linenc := proc(x, x0, fx0, fpX)
			   begin
			     // f(x0) + f'(X)*(x-x0),
			     // without signalling underflows
			     rdplus(fx0,
				    rdmult(fpX,
					   rdsubtract(x, x0, 0), 0), 0);
			   end_proc:
		 
		 // inclusion of second order:
		 // must not use linear connections then!
		 polyenc := proc(x, x0, fx0, fpx0, fppX)
			    begin
			      // f(x0) + f'(x0)*(x-x0)+f''(X)/2*(x-x0)^2,
			      // written to be safe from arithmetical
			      // underflows
			      x := rdsubtract(x, x0, 0);
			      rdplus(fx0,
				     rdplus(rdmult(fpx0, x, 0),
					    rdmult(fppX,
						   rdmult(x, x, 0), 0), 0), 0);
			    end_proc:
		 
		 if not has([fx, fppx, fxl, fpxl, fxr, fpxr], I) then
		   xs := [((submesh + 1 - i) * xl + i * xr)/(submesh + 1)
			  $ i = 0..submesh+1];
//		   c1 := map(xs, x -> [x,
//				       max(polyenc(x, xl, lhs(fxl),
//						   lhs(fpxl), lhs(fppx)),
//					   polyenc(x, xr, lhs(fxr),
//						   rhs(fpxr), lhs(fppx)),
//					   lhs(fx))]);
//		   c2 := map(xs, x -> [x,
//				       min(polyenc(x, xl, rhs(fxl),
//						   rhs(fpxl), rhs(fppx)),
//					   polyenc(x, xr, rhs(fxr),
//						   lhs(fpxr), rhs(fppx)),
//					   rhs(fx))]);
		   c1 := map(xs, x -> [x,
				       max(linenc(x, xl, lhs(fxl), lhs(fpx)),
					   linenc(x, xr, lhs(fxr), rhs(fpx)))]);
		   c2 := map(xs, x -> [x,
				       min(linenc(x, xl, rhs(fxl), rhs(fpx)),
					   linenc(x, xr, rhs(fxr), lhs(fpx)))]);
		 end_if;
	       end_if;
	       
	       if xs = FAIL then
		 // submesh = 0 or non-real values
		 fx := hull(f(xiv));
		 if iszero(Im(fx)) then
		   xs := [xl, xr];
		   c1 := [[xl, rhs(fx)], [xr, rhs(fx)]];
		   c2 := [[xl, lhs(fx)], [xr, lhs(fx)]];
		 end_if;
	       end_if;
	       
	       if xs <> FAIL then
                 c1 := map(c1,X->[X[1],max(min(X[2], 1e300), -1e300)]);
                 c2 := map(c2,X->[X[1],max(min(X[2], 1e300), -1e300)]);
                 out::writePoly2d(attributes, table("LinesVisible"=FALSE), c2.revert(c1));
                 out::writePoly2d(attributes, table("Filled" = FALSE, "Closed" = FALSE), c1);
                 out::writePoly2d(attributes, table("Filled" = FALSE, "Closed" = FALSE), c2);
                 ymin := min(ymin,  op(map(c1.c2,op,2)));
                 ymax := max(ymax,  op(map(c1.c2,op,2)));
	       end_if;
	     end_proc:
  
  for xminmax in branches do
    [xmin, xmax] := [op(xminmax)];
    xr := xmin;
    for i from 1 to mesh-1 do
      [xl, xr] := [xr, ((mesh - 1 - i)* xmin + i*xmax)/(mesh-1)];
      plotSeg(subsop(xminmax, 1=xl, 2=xr));
    end_for;
  end_for;
  
  if {ymin, ymax} intersect {RD_NINF, RD_INF} = {} then
    [attributes[XMin] .. attributes[XMax],
     ymin .. ymax];
  else
    null();
  end_if;
end_proc:

