/* ----------------------------------------------------------------------------
plot::Icosahedron -- graphical primitive of a isocahedron

Call(s):
    plot::Icosahedron( <args, ...> )

Parameters:
    -

Options:
    attr, ...   : plot options, i.e., equations Attribute = value, where
                  Attribute is one of the attributes listed below or a hint.

Related Domains:
    plot::Tetrahedron, plot::Hexahedron, plot::Octahedron, plot::Dodecahedron,
    plot::Box, plot::Cone, plot::Cylinder, plot::Ellipsoid, plot::Sphere, plot::Rotate3d,
    plot::Scale3d, plot::Translate3d

Example:
    >> plot( plot::Icosahedron() );

Further Reading:
    Refer to Tetrahedron.mu

---------------------------------------------------------------------------- */

// remove
// unprotect(plot): plot::Icosahedron:=FAIL:

//-----------------------------------------------------------------------------
plot::createPlotDomain("Icosahedron", "graphical primitive for surface sets", 3,
   [
    CenterX, CenterY, CenterZ, Center, Radius,
    LinesVisible, LineStyle, LineWidth,
    LineColor, LineColorType, LineColor2, LineColorFunction, Color,
    Filled, FillColor, FillColorType, FillColor2, FillColorFunction,
    Shading,
    PointsVisible, PointStyle, PointSize,
    LineColorDirectionX, LineColorDirectionY, LineColorDirectionZ,
    LineColorDirection, FillColorDirection,
    FillColorDirectionX, FillColorDirectionY, FillColorDirectionZ
   ]
):

//-----------------------------------------------------------------------------
plot::Icosahedron::styleSheet:= table(
      LinesVisible  = TRUE,
      LineColor     = RGB::Black.[0.25],
      Radius        = 1,
      CenterX       = 0,
      CenterY       = 0,
      CenterZ       = 0,
      LineColorDirectionY=0
):

//-----------------------------------------------------------------------------
plot::Icosahedron::hints:= {
      Scaling = Constrained
}:

//-----------------------------------------------------------------------------
plot::Icosahedron::new:= proc()
local  object, other;
option escape;
begin
    // filter out all generic arguments
    object:= dom::checkArgs([],args());

    // process the special attributes in object::other
    other:= object::other;
    if nops(other) > 0 then
      error("unexpected argument: ".expr2text(other[1]));
    end_if;

    // check all attributes
    dom::checkObject(object);
end_proc:

//-----------------------------------------------------------------------------
plot::Icosahedron::print:= obj -> "plot::Icosahedron(...)":

//-----------------------------------------------------------------------------
plot::Icosahedron::doPlotStatic:= proc(out, object, attributes, inheritedAttributes)
    // object:              object that was created by the new method above.
    // attributes:          table of all attributes. hints are not included.
    // inheritedAttributes: just ignore it.
local
    cx, cy, cz, r, p, q,
    triangles,
    fillcolorfunction,
    linecolorfunction, haslinecolorfunction,
    tn, i,
    entries;

begin
    // check for fill-color function
    if contains(attributes, FillColorFunction) then
      fillcolorfunction:= float@(attributes[FillColorFunction]); // procedure
    else fillcolorfunction:= () -> null();
    end_if;

    // check for line-color function
    if contains(attributes, LineColorFunction) then
      linecolorfunction:= float@(attributes[LineColorFunction]); // procedure
      haslinecolorfunction:= TRUE;
    else linecolorfunction:= () -> null();
         haslinecolorfunction:= FALSE;
    end_if;

    cx:= float(attributes[CenterX]);
    cy:= float(attributes[CenterY]);
    cz:= float(attributes[CenterZ]);
    r := float(attributes[Radius]);
    r := r*0.982;  // hack: scale to embed into hexahedron
    q := r;
    p := float(r*(sqrt(5)-1)/2);

    triangles:= [
      [cx+p,cy+0,cz+q], [cx-p,cy+0,cz+q], [cx+0,cy+q,cz+p],
      [cx+p,cy+0,cz+q], [cx-p,cy+0,cz+q], [cx+0,cy-q,cz+p],
      [cx-p,cy+0,cz+q], [cx+0,cy+q,cz+p], [cx-q,cy+p,cz+0],
      [cx-p,cy+0,cz+q], [cx-q,cy+p,cz+0], [cx-q,cy-p,cz+0],
      [cx+p,cy+0,cz+q], [cx+q,cy+p,cz+0], [cx+0,cy+q,cz+p],
      [cx+p,cy+0,cz+q], [cx+q,cy-p,cz+0], [cx+q,cy+p,cz+0],
      [cx+q,cy+p,cz+0], [cx+q,cy-p,cz+0], [cx+p,cy+0,cz-q],
      [cx+q,cy+p,cz+0], [cx+0,cy+q,cz-p], [cx+0,cy+q,cz+p],
      [cx+q,cy+p,cz+0], [cx+0,cy+q,cz-p], [cx+p,cy+0,cz-q],
      [cx-p,cy+0,cz-q], [cx+0,cy+q,cz-p], [cx-q,cy+p,cz+0],
      [cx+0,cy+q,cz-p], [cx-q,cy+p,cz+0], [cx+0,cy+q,cz+p],
      [cx+p,cy+0,cz-q], [cx-p,cy+0,cz-q], [cx+0,cy+q,cz-p],
      [cx+p,cy+0,cz+q], [cx+q,cy-p,cz+0], [cx+0,cy-q,cz+p],
      [cx+0,cy-q,cz+p], [cx-p,cy+0,cz+q], [cx-q,cy-p,cz+0],
      [cx+0,cy-q,cz+p], [cx+0,cy-q,cz-p], [cx-q,cy-p,cz+0],
      [cx+p,cy+0,cz-q], [cx-p,cy+0,cz-q], [cx+0,cy-q,cz-p],
      [cx+0,cy-q,cz-p], [cx-p,cy+0,cz-q], [cx-q,cy-p,cz+0],
      [cx-p,cy+0,cz-q], [cx-q,cy+p,cz+0], [cx-q,cy-p,cz+0],
      [cx+q,cy-p,cz+0], [cx+0,cy-q,cz-p], [cx+p,cy+0,cz-q],
      [cx+0,cy-q,cz+p], [cx+0,cy-q,cz-p], [cx+q,cy-p,cz+0]
    ];

    // start to write triangle mesh to XML stream
    triangles := zip([([ (i-1 div 3)+1,0])$i=1..nops(triangles)], triangles, _concat);
    out::writeTriangles(attributes, table("MeshVisible"   = FALSE, "PointsVisible" = FALSE, "HasLineColors" = FALSE),
      triangles, (u,v,x,y,z)->fillcolorfunction(u,x,y,z));
    // write triangle lines to XML stream
    for tn from 3 to nops(triangles) step 3 do
      out::writePoly3d(attributes, table("Filled" = FALSE, "Closed" = TRUE),
        [op(triangles,(tn-2)..(tn))], (u,v,x,y,z)->linecolorfunction(u,x,y,z), 3..5);
    end_for;

    // finally, return the viewing box
    entries:= (i) -> map(triangles,op,i);
    return( [min(entries(3))..max(entries(3)),
             min(entries(4))..max(entries(4)),
             min(entries(5))..max(entries(5))] );
  end_proc:
//------------------------------------------------------------------------

// remove
// protect(plot, ProtectLevelError): null():

//------------------------------------------------------------------------