// 

plot::createPlotDomain("Iteration",
                       "graphical primitive for iterated functions",
                       2,
                       [Function, XName, XMin, XMax,
                        LineWidth, LineStyle, LineColor, Color, AntiAliased,
                        [StartingPoint, ["Mandatory", NIL],
                        ["Definition", "Expr", FAIL,
                         "Starting point of the iteration.", TRUE]],
                        [Iterations, ["Optional", 10],
                        ["Definition", "Expr", FAIL,
                         "Number of iteration steps.", TRUE]]]):

plot::Iteration::styleSheet := table(LineColor = RGB::Grey50,
                                     AntiAliased = FALSE,
                                     LineStyle = Solid):

//------------------------------------------------------------------------
// Hints for parents:
plot::Iteration::hints := {Scaling = Constrained}:
//------------------------------------------------------------------------


plot::Iteration::new :=
 proc()
  local object, other;
 begin
  object := dom::checkArgs(["X"], args());

  other := object::other;

  if nops(other) > 0 then
    object::Function := other[1];
  end_if;
  if nops(other) > 1 then
    object::StartingPoint := other[2];
  end_if;
  if nops(other) > 2 then
    object::Iterations := other[3];
  end_if;
  if nops(other) > 3 then
    error("unexpexted argument ".expr2text(object[4]));
  end_if;

  dom::checkObject(object);
 end_proc:

plot::Iteration::print := 
  proc(i)
  begin
    if i::Iterations = FAIL then
      hold(plot::Iteration)(i::Function, i::XName=i::XRange, i::StartingPoint);
    else
      hold(plot::Iteration)(i::Function, i::XName=i::XRange, i::StartingPoint, i::Iterations);
    end_if;
  end_proc:

plot::Iteration::doPlotStatic :=
  proc(out, obj, attributes, inherited_attributes)
    local xname, x, fx, i, f, xmin, xmax, iter, points;
  begin
    xname := attributes[XName];
    x     := float(attributes[StartingPoint]);
    f     := attributes[Function];

    xmin := x;
    xmax := x;

    points := [[x,0]];

    for i from 1 to floor(attributes[Iterations]) do
      fx := f(x);
      points := points.[[x, fx]];
      if float(fx) < float(attributes[XMin]) or 
         float(fx) > float(attributes[XMax]) then 
         break; 
      end_if;
      x := fx;
      if specfunc::abs(x) < 1e-200 then
         // no chance to use prP2(x, x) --> clip to 0.0
         x:= float(0); 
      end_if;
      points := points.[[x, x]];
      xmin := min(x, xmin);
      xmax := max(x, xmax);
    end_for;
    
    // For animated values of the Iterations attribute,
    // iter will be float!
    iter := frac(attributes[Iterations]);
    if not iszero(iter) then
      fx := f(x);
      points := points.[[x, x+min(2*iter, 1)*(fx-x)]];
      if float(iter) > 0.5 then
        points := points.[[x + min(2*iter-1, 1)*(fx-x), fx]];
        xmin := min(xmin, x + min(2*iter-1, 1)*(fx-x));
        xmax := max(xmax, x + min(2*iter-1, 1)*(fx-x));
      end_if;
      xmin := min(xmin, x+min(2*iter, 1)*(fx-x));
      xmax := max(xmax, x+min(2*iter, 1)*(fx-x));
    end_if;

    out::writePoly2d(attributes, table("Closed"=FALSE, "Filled"=FALSE), points);
    // ViewingBox
    [xmin..xmax, min(0, xmin)..max(0, xmax)];
  end_proc:
