// 

// plot primitive - plot::MuPADCube
//                  The MuPADCube Cube
//
//
//
//
// 

plot::createPlotDomain("MuPADCube",
                       "graphical primitive for a 3D MuPADCube cube",
                       3,
                       [CenterX, CenterY, CenterZ, Center, Radius,
                        Colors//, Color
                       ]):

plot::MuPADCube::styleSheet :=
  table(CenterX=0, CenterY=0, CenterZ=0,
        Center = [0, 0, 0], Radius = 1,
        Colors = [RGB::Green, RGB::Blue, RGB::Red, RGB::Yellow, RGB::Antique]):

// Hints for parents:
plot::MuPADCube::hints := {Axes = None, Scaling = Constrained}:

// here we have to do something
plot::MuPADCube::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;

    if testargs() and nops(other) > 0 then
      if nops(other) > 2 then
        error("unexpected argument: ".expr2text(other[3]))
      end_if;

      if not testtype(other[1], Type::Arithmetical) then
        error("1st argument: expecting an expression (the radius)")
      end_if;

      if nops(other) = 2 and
        not testtype(other[2],
                     Type::ListOf(Type::Arithmetical, 3, 3)) and
        not (other[2])::dom::hasProp(Cat::Matrix)=TRUE then
        error("2nd argument: expecting a list of 3 expressions (the center)")
      end_if;
    end_if;
    
    if nops(other) > 0 then
      object::Radius := other[1];
      if nops(other) = 2 then
        object::Center := other[2];
      end_if;
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::MuPADCube::print :=
  obj -> hold(plot::MuPADCube)(/*obj::Radius, obj::Center*/):

plot::MuPADCube::doPlotStatic:=
  proc(out, obj, attrib, inherited)
    local radius, k, l, m, cx, cy, cz, rcc, rcone, rcube, ccone;
  begin
    radius := float(attrib[Radius])/2.2;
    [cx, cy, cz] := [float(attrib[CenterX]), float(attrib[CenterY]), float(attrib[CenterZ])];
    if radius = 0.0 then
      return([cx..cx,cy..cy,cz..cz])
    end_if;
    // relations of the objects
    rcube := radius/2.2;
    rcone := radius/6;
    rcc := rcube*cos(arcsin(rcone/rcube));

    //if attrib[Color] <> [] then // color explicitely set
    //  attrib[Colors] := [attrib[Color] $ 5]
    //end_if;
    
    if nops(attrib[Colors]) < 5 then
      ccone := RGB::Antique; // default color, when no fifth color is given!
      attrib[Colors] := _concat(attrib[Colors] $ 5 - nops(attrib[Colors]))
    else
      ccone := attrib[Colors][5];
      delete attrib[Colors][5] // if more colors are given
    end_if;
    
    // group of eight spheres
    out::writeSphere(attrib, table("FillColor"  = (if nops(attrib[Colors]) = 6 then // special case 2/3 Colors
                                                attrib[Colors][1 + (k+1)/2 + (l+1)/2 + (m+1)/2]
                                              elif nops(attrib[Colors]) < 8 then // default
                                                attrib[Colors][5 - ((abs(l + 2*m + 4*k)/2) + 1/2)]
                                              else // all (sphere) colors different
                                                attrib[Colors][1 + (k + 1)/2 + (l + 1) + 2*(m + 1)]
                                              end_if)),
                                          cx + k*radius,
                                          cy + m*radius,
                                          cz + l*radius,
                                          rcube) $ k in [-1, 1] $ l in [-1, 1] $ m in [-1, 1];
    // three groups of four cylinders
    (out::writeCone(attrib, table("LinesVisible" = FALSE, "FillColor" = ccone),
      cx + -radius + rcc, cy + k*radius, cz + l*radius,
      cx + radius - rcc, cy + k*radius, cz + l*radius,
      rcone, rcone),
      out::writeCone(attrib, table("LinesVisible" = FALSE, "FillColor" = ccone),
      cx + k*radius, cy + -radius + rcc, cz + l*radius,
      cx + k*radius, cy + radius - rcc, cz + l*radius,
      rcone, rcone),
      out::writeCone(attrib, table("LinesVisible" = FALSE, "FillColor" = ccone),
      cx + k*radius, cy + l*radius, cz + -radius + rcc,
      cx + k*radius, cy + l*radius, cz + radius - rcc,
      rcone, rcone)
      ) $ k in [-1, 1] $ l in [-1, 1];
    return([cx-1.5*radius..cx+1.5*radius,
            cy-1.5*radius..cy+1.5*radius,
            cz-1.5*radius..cz+1.5*radius]);
  end_proc:
