//      

/* -----------------------------------------------------------
    Point2d -- The graphical primitive for 2D points

    Syntax:
    Point2d(x, y<, op1, op2, ...>)

    x, y         : arithmetical expressions
    op1, op2, ...: plot options of the form 'option = value'

    Example:
    >> plot::Point2d(1, 2)

    >> plot::Point2d(1, 2, PointSize = 12)

    >> plot::Point2d(matrix([1, 2]), PointSize = 12)
----------------------------------------------------------------*/ 

// creates the domain plot::Point2d and sets generic entries like:
// dimension, op, nops, subsop, slot, _index, _set_index, print, ...
plot::createPlotDomain("Point2d",
                       "graphical primitive for 2D points"):

//-----------------------------------------------------------------------------
plot::Point2d::styleSheet:= table(
      PositionX = 0,
      PositionY = 0
):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Point2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    // convert row or column vector to a list of expressions
    if nops(other) > 0 and (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
      other[1]:= [op(other[1])];
    end_if;

    if nops(other) = 1 then
       if domtype(other[1]) = DOM_LIST and
            nops(other[1]) = 2 then
            // validity check is done by the slot assignment
            object::Position := op(other);
       else error("expecting a list [x, y] of coordinates");
       end_if;
    elif nops(other) = 2 then
       if domtype(other[1]) = DOM_LIST then
          error("unexpected argument: ".expr2text(op(other, 2)))
       end_if;
       // validity check is done by the slot assignment
       object::Position := other;
    elif nops(other) > 2 then
      // if nops(other) = 0, the user is expected to have set PositionX 
      // and PositionY directly in the argument list; this is checked
      // below in dom::checkObject
      error("unexpected argument: ".expr2text(op(other, 3)))
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:                          /* end of method new */

plot::Point2d::print :=
obj -> hold(plot::Point2d)(op(obj::Position),
                           dom::printAttributes(obj, {Position})):

plot::Point2d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    return(out::writePoint2d(attrib, table("PointsVisible"=TRUE),
      float(attrib[PositionX]),
      float(attrib[PositionY])));
  end_proc:
