//      

/* -----------------------------------------------------------
    Point3d -- The graphical primitive for 3D points

    Syntax:
    Point3d(x, y, z<, op1, op2, ...>)

    x, y, z      : arithmetical expressions
    op1, op2, ...: plot options of the form 'option = value'

    Example:
    >> plot::Point3d(1, 2, 3)

    >> plot::Point3d(1, 2, 3, PointSize = 12)

    >> plot::Point3d(matrix([1, 2, 3]), PointSize = 12)
----------------------------------------------------------------*/ 

plot::createPlotDomain("Point3d",
                       "graphical primitive for 3D points"):

//-----------------------------------------------------------------------------
plot::Point3d::styleSheet:= table(
      PositionX = 0,
      PositionY = 0,
      PositionZ = 0
):

// methods yet to be implemented:  convert, convert_to, expr

// here we have to do something
plot::Point3d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    // convert row or column vector to a list of expressions
    if nops(other) > 0 and (other[1])::dom::hasProp(Cat::Matrix)=TRUE then
      other[1]:= [op(other[1])];
    end_if;

    if nops(other) = 1 then
       if domtype(other[1]) = DOM_LIST and
           nops(other[1]) = 3 then
          // validity check is done by the slot assignment
          object::Position := op(other);
       else error("expecting a list [x, y, z] of coordinates");
       end_if;
    elif nops(other) = 2 then
       if domtype(other[1]) = DOM_LIST then
          error("unexpected argument: ".expr2text(op(other, 2)))
       else
          error("expecting 3 arguments x, y, z (the position)");
       end_if;
    elif nops(other) = 3 then
       if domtype(other[1]) = DOM_LIST then
          error("unexpected argument: ".expr2text(op(other, 2)))
       end_if;
       if domtype(other[2]) = DOM_LIST then
          error("unexpected argument: ".expr2text(op(other, 3)))
       end_if;
       // validity check is done by the slot assignment
       object::Position := other;
    elif nops(other) > 3 then
      // if nops(other) = 0, the user is expected to have set PositionX 
      // and PositionY directly in the argument list; this is checked
      // below in dom::checkObject
      error("unexpected argument: ".expr2text(op(other, 4)))
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Point3d::print :=
obj -> hold(plot::Point3d)(op(obj::Position),
                           dom::printAttributes(obj, {Position})):

plot::Point3d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
  begin
    out::writePoint3d(attrib, table(), float(attrib[PositionX]), float(attrib[PositionY]), float(attrib[PositionZ]));
end_proc:
