//      

/* -----------------------------------------------------------
    PointList3d -- an opaque list of 3D points

    Syntax:
    PointList3d(f, var=a..b, <, op1, op3, ...>)

    f, a, b               : arithmetical expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::PointList3d([[1, 2, 3], [2, 3, 4]])

    >> plot::PointList3d([[1, 2, 3, [0.5, 0.5, 0.5]], [2, 3, 4, [1.0, 0.0, 0.1]]],
                         PointStyle = XCrosses)
----------------------------------------------------------------*/ 

plot::createPlotDomain("PointList3d",
                       "an opaque list of 3D points",
                       3,  // Dimension
   [Points3d, PointStyle, PointSize, PointColor, Color]):

//-------------------------------------------
plot::PointList3d::new :=
  proc()
    local object, other;
  begin
    object := dom::checkArgs([], args());
    
    other := object::other;
  
    if nops(other) = 1 then
      // object::Points3d := other[1];
      dom::changeNotifier(object, "Points3d" = other[1]);
    elif nops(other) <> 0 then
      error("unexpected argument: ".expr2text(other[2]));
    end_if;

    dom::checkObject(object);
end_proc:
//-------------------------------------------
plot::PointList3d::changeNotifier :=
  proc(object, eq)
    local slotName, newval, l, i, j;
  begin
    [slotName, newval] := [op(eq)];
    case slotName
      of "Points3d" do
        l := newval;
        if l::dom::hasProp(Cat::Matrix) = TRUE then
           l:= expr(l);
        end_if;
        if domtype(l) = DOM_ARRAY then
           if op(l, [0, 1]) <> 2 then
              error("expecting an array/matrix with 3 columns");
           end_if;
           if op(l, [0, 3, 2]) < op(l, [0, 3, 1]) + 2 then
              error("expecting an array/matrix with 3 columns");
           end_if;
           l:=[ [l[i,j] $ j = op(l, [0,3,1])..op(l, [0,3,1]) + 2]
                        $ i = op(l, [0,2,1])..op(l, [0,2,2])];
        end_if;
        dom::extslot(object, "Points3d", l);

        return(FALSE); // we've done all there is to do
        break;
    end_case;
    return(TRUE);
end_proc:
//-------------------------------------------
plot::PointList3d::print :=
  obj -> if nops(obj::Points3d) < plot::pointsInObjectInspector() then
           hold(plot::PointList3d)(obj::Points3d,
                                   dom::printAttributes(obj, {Points3d})):
         else
           hold(plot::PointList3d)([hold(`...`)],
                                   dom::printAttributes(obj, {Points3d})):
         end_if:

//-------------------------------------------
plot::PointList3d::doPlotStatic:=
  proc(out, object, attributes, inherited)
  begin
    out::writePoints3d(attributes, table("PointsVisible"=TRUE), float(attributes[Points3d]), 
      (()->if args(0) > 3 then args(4) end),
      1..3);
  end_proc:
