// 

// plot::Polar -- curves in polar coordinates

plot::createPlotDomain("Polar",
		       "graphical primitive for curves in polar coordinates",
		       2,
             [XFunction, YFunction,
             UName, UMin, UMax,
             UMesh, Mesh, USubmesh, Submesh, AdaptiveMesh,
             DiscontinuitySearch,
             LineWidth, LineStyle, LinesVisible, AntiAliased,
             LineColor, Color, LineColor2,
             LineColorType, LineColorFunction,
             PointSize, PointStyle, PointsVisible,
             LineColorDirection, LineColorDirectionX, LineColorDirectionY
         ]):

//------------------------------------------------------------------------
// Hints for parents:
plot::Polar::hints := {Scaling = Constrained}:
//------------------------------------------------------------------------
plot::Polar::styleSheet := table(LegendEntry = TRUE,
                                 UMesh = 121):

plot::Polar::new :=
  proc()
    local object, other;
  begin
    object := dom::checkArgs(["U"], args());
    
    other := object::other;
    
    if nops(other) > 0 then
      if nops(other) > 1 then
        error("unexpected argument ".expr2text(other[2]));
      end_if;
      if domtype(other[1]) <> DOM_LIST or
        nops(other[1]) <> 2 then
          if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
            other[1]:= [op(other[1])];
          else 
            error("expecting a list of two expressions");
          end_if;
      end_if;
      object::XFunction := other[1][1];
      object::YFunction := other[1][2];
    end_if;
    
    dom::checkObject(object);
  end_proc:
  
plot::Polar::print := p -> hold(plot::Polar)([p::XFunction, p::YFunction],
					     p::UName = p::URange):
					     
plot::Polar::doPlotStatic :=
  proc(out, p, attributes, inheritedAttributes)
    local x, y, u, cleaned_att;
  begin
    u := attributes[UName];
    x := attributes[XFunction];
    y := attributes[YFunction];
    cleaned_att := out::fixAttributes(attributes, plot::Curve2d);
    cleaned_att[XFunction] := x*(cos@y);
    cleaned_att[YFunction] := x*(sin@y);
    if contains(cleaned_att, LineColorFunction) then
      cleaned_att[LineColorFunction] := 
      subs(((t) -> `#f`(t,
			`#r`(t),
			`#phi`(t),
			args(2..args(0)))),
	   [`#f` = cleaned_att[LineColorFunction],
	    `#r` = attributes[XFunction],
	    `#phi` = attributes[YFunction]]);
    end_if;
    out(plot::Curve2d(op(cleaned_att)),
		   inheritedAttributes, Raw):
  end_proc:
