//      

/* -----------------------------------------------------------
    Polygon2d -- The graphical primitive for 2D polygons

    Syntax:
    Polygon2d([list, ...]<, op1, op2, ...>)

    list         : list of 2 arithmetical expressions and an optional color value
    op1, op2, ...: plot options of the form 'option = value'

    Example:
    >> plot::Polygon2d([[1, 2], [2, 3]])

    >> plot::Polygon2d([[1, 2, [0.5, 0.5, 0.5]], [2, 3, 1.0, 0.0, 0.1]])

    >> plot::Polygon2d([[1, 2], [2, 3]], PointStyle = XCrosses)

    >> plot::Polygon2d(matrix([[1,2],[3,4],[1,4], [9,16]]))
----------------------------------------------------------------*/ 

plot::createPlotDomain("Polygon2d",
                       "graphical primitive for 2D polygons"):

plot::Polygon2d::styleSheet:= table(
      Filled = FALSE
):

plot::Polygon2d::setPrimaryColor(LineColor):


// methods yet to be implemented:  convert, convert_to, expr

//-------------------------------------------
plot::Polygon2d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) = 1 then
      // object::Points2d := other[1];
      dom::changeNotifier(object, "Points2d" = other[1]);
    elif nops(other) <> 0 then
      error("expecting a list of lists with 2 expressions and an optional color value")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:                             /* end of method new */
//-------------------------------------------
plot::Polygon2d::changeNotifier :=
  proc(object, eq)
    local slotName, newval, l, i, j;
  begin
    [slotName, newval] := [op(eq)];
    case slotName
      of "Points2d" do
        l := newval;
        if l::dom::hasProp(Cat::Matrix) = TRUE then
           l:= expr(l);
        end_if;
        if domtype(l) = DOM_ARRAY then
           if op(l, [0, 1]) <> 2 then
              error("expecting an array/matrix with 2 columns");
           end_if;
           if op(l, [0, 3, 2]) = op(l, [0, 3, 1]) then
              error("expecting an array/matrix with 2 columns");
           end_if;
           l:=[ [l[i,j] $ j = op(l, [0,3,1])..op(l, [0,3,1]) + 1]
                        $ i = op(l, [0,2,1])..op(l, [0,2,2])];
        end_if;
        dom::extslot(object, "Points2d", l);

        return(FALSE); // we've done all there is to do
        break;
    end_case;
    return(TRUE);
end_proc:
//-------------------------------------------
plot::Polygon2d::print :=
  obj -> if nops(obj::Points2d) < 10 then
           hold(plot::Polygon2d)(obj::Points2d):
         else
           hold(plot::Polygon2d)():
         end_if:
//-------------------------------------------
plot::Polygon2d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
    local points, colFunc, i;
  begin
    points := float(attrib[Points2d]);
    if contains(attrib, LineColorFunction) then
      colFunc := attrib[LineColorFunction]
    else
      colFunc := null():
    end_if;

    points := zip(points, [([i])$ i=1..nops(points)], _concat);
    return(out::writePoly2d(attrib, table(),
      points, colFunc));
  end_proc:
