//      

/* -----------------------------------------------------------
    Polygon3d -- The graphical primitive for 3D polygons

    Syntax:
    Polygon3d([list, ...]<, op1, op2, ...>)

    list         : list of 3 arithmetical expressions and an optional color value
    op1, op2, ...: plot options of the form 'option = value'

    Example:
    >> plot::Polygon3d([[1, 2, 3], [2, 3, 4]])

    >> plot::Polygon3d([[1, 2, 3, [0.5, 0.5, 0.5]], [2, 3, 4, [1.0, 0.0, 0.1]]])

    >> plot::Polygon3d([[1, 2, 3], [2, 3, 4]], PointStyle = FilledSquares)

    >> plot::Polygon3d(matrix([[1,2,3], [4,9,16],[2,3,4]]))
----------------------------------------------------------------*/ 

plot::createPlotDomain("Polygon3d",
                       "graphical primitive for 3D polygons"):

plot::Polygon3d::styleSheet := table(// Filled works only for triangles
                    FillColor = RGB::LightBlue,
                    Filled=FALSE,
                    LineColorDirectionY=0):

plot::Polygon3d::setPrimaryColor(LineColor):

// methods yet to be implemented:  convert, convert_to, expr

//-------------------------------------------
plot::Polygon3d::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if nops(other) = 1 then
      // object::Points3d := other[1];
      dom::changeNotifier(object, "Points3d" = other[1]);
    elif nops(other) <> 0 then
      error("expecting a list of lists with 3 expressions and an optional color value")
    end_if;

    // semantically check for validity
    dom::checkObject(object);
  end_proc:                             /* end of method new */
//-------------------------------------------
plot::Polygon3d::changeNotifier :=
  proc(object, eq)
    local slotName, newval, l, i, j;
  begin
    [slotName, newval] := [op(eq)];
    case slotName
      of "Points3d" do
        l := newval;
        if l::dom::hasProp(Cat::Matrix) = TRUE then
           l:= expr(l);
        end_if;
        if domtype(l) = DOM_ARRAY then
           if op(l, [0, 1]) <> 2 then
              error("expecting an array/matrix with 3 columns");
           end_if;
           if op(l, [0, 3, 2]) < op(l, [0, 3, 1]) + 2 then
              error("expecting an array/matrix with 3 columns");
           end_if;
           l:=[ [l[i,j] $ j = op(l, [0,3,1])..op(l, [0,3,1]) + 2]
                        $ i = op(l, [0,2,1])..op(l, [0,2,2])];
        end_if;
        dom::extslot(object, "Points3d", l);

        return(FALSE); // we've done all there is to do
        break;
    end_case;
    return(TRUE);
end_proc:
//-------------------------------------------
plot::Polygon3d::print :=
  obj -> if nops(obj::Points3d) < 10 then
           hold(plot::Polygon3d)(obj::Points3d):
         else
           hold(plot::Polygon3d)():
         end_if:
//-------------------------------------------
plot::Polygon3d::doPlotStatic:=
  proc(out, obj, attrib, inherited)
    local points, colFunc, i;
  begin
    points := float(attrib[Points3d]);
    points := map(points, X->[0,0].X);
    points := zip(points, [([i])$ i=1..nops(points)], _concat);
    if contains(attrib, LineColorFunction) then
      colFunc := (u,v,x,y,z,i)->attrib[LineColorFunction](x,y,z,i);
    else
      colFunc := null();
    end_if;
    return(out::writePoly3d(attrib, table(), points, colFunc));
  end_proc:
