//      

/* -----------------------------------------------------------
    Rectangle -- The graphical primitive for 2D rectangles

    Syntax:
    Rectangle(range1, range2<, op1, op2, ...>)

    range1, range2         : ranges of expressions
    op1, op2, ...          : options of the form 'option = value'

    Example:
    >> plot::Rectangle(-5..5, -5..5)

----------------------------------------------------------------*/ 

plot::createPlotDomain("Rectangle",
                       " graphical primitive for 2D rectangles"):

// methods yet to be implemented:  convert, convert_to, expr
plot::Rectangle::styleSheet := table(
                                     XMin   = -1,
                                     XMax   =  1,
                                     YMin   = -1,
                                     YMax   =  1,
                                     AntiAliased = FALSE,
                                     Filled = FALSE
):
plot::Rectangle::setPrimaryColor(LineColor):

// here we have to do something
plot::Rectangle::new:=
  proc()
    local object, other;
  begin
    // check all known options from the argument list
    object := dom::checkArgs([], args());
    
    // get arguments which are not yet processed
    other := object::other;
    
    if not testtype(other,
                    Type::ListOf("_range", 2, 2)) then
       if nops(other) = 1 then
          if (other[1])::dom::hasProp(Cat::Matrix) = TRUE and
             (other[1])::matdim = [2, 2] then
                other:=  [ [other[1,1] .. other[2,1]],
                           [other[1,2] .. other[2,2]] ]:
          else
             error("invalid range specification");
          end_if;
       end_if;

       if nops(other) = 2 then
          if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
           other[1]:= [op(other[1])];
          end_if;
          if (other[2])::dom::hasProp(Cat::Matrix) = TRUE then
           other[2]:= [op(other[2])];
          end_if;
          if domtype(other[1]) = DOM_LIST and 
             nops(other[1]) = 2 and
             domtype(other[2]) = DOM_LIST and 
             nops(other[2]) = 2 then
               other:= [other[1][1] .. other[2][1],
                        other[1][2] .. other[2][2]];
          end_if;
       end_if;
    end_if;
      
    if testargs() and nops(other) > 0 then
      if not testtype(map(op(other), op),
                    Type::SequenceOf(Type::Arithmetical, 4, 4)) then
         error("expecting 2 ranges of expressions")
      end_if;
    end_if;

    if nops(other) > 0 then
      object::XRange   := other[1];
      object::YRange   := other[2];
    end_if;
    
    // semantically check for validity
    dom::checkObject(object);
  end_proc:

plot::Rectangle::print :=
  obj -> hold(plot::Rectangle)(obj::XRange, obj::YRange):

plot::Rectangle::doPlotStatic:=
  proc(out, obj, attrib, inhertied)
  local xmin, xmax, ymin, ymax;
  begin
    [xmin, xmax]:= float([attrib[XMin], attrib[XMax]]);
    [ymin, ymax]:= float([attrib[YMin], attrib[YMax]]);
    out::writePoly2d(attrib, table("Closed"=TRUE), [[xmin, ymin],
      [xmin, ymax], [xmax, ymax], [xmax, ymin]]);
  end_proc:
