// 

// plot::Spherical -- surfaces in spherical coordinates

plot::createPlotDomain("Spherical",
                       "graphical primitive for surfaces in spherical coordinates",
                       3,
                       [XFunction, YFunction, ZFunction, 
                        UName, UMin, UMax, URange, VName, VMin, VMax, VRange,
                        UMesh, VMesh, Mesh, USubmesh, VSubmesh, Submesh, AdaptiveMesh,
                        Filled, FillColor, Color, FillColor2, FillColorType, FillColorFunction,
                        LineWidth, LineStyle, MeshVisible,
                        LineColor, LineColor2,
                        LineColorType, LineColorFunction,
                        PointSize, PointStyle, PointsVisible, 
			ULinesVisible, VLinesVisible,
			XContours, YContours, ZContours,
         LineColorDirectionX, LineColorDirectionY, LineColorDirectionZ,
         LineColorDirection, FillColorDirection,
         FillColorDirectionX, FillColorDirectionY, FillColorDirectionZ
                       ]):

//------------------------------------------------------------------------
// Hints for parents:
plot::Spherical::hints := {Scaling = Constrained}:

plot::Spherical::styleSheet := table(LegendEntry = TRUE,
                                     LineColor = RGB::Black.[0.25],
                                     MeshVisible = FALSE,
                                     LineColorDirectionY=0):
//------------------------------------------------------------------------

plot::Spherical::new :=
  proc()
    local object, other;
  begin
    object := dom::checkArgs(["U", "V"], args());    
    other := object::other;
    
    if nops(other) > 0 then
      if nops(other) > 1 then
        error("unexpected argument ".expr2text(other[2]));
      end_if;
      if (other[1])::dom::hasProp(Cat::Matrix) = TRUE then
         other[1]:= [op(other[1])];
      end_if;
      if domtype(other[1]) <> DOM_LIST or
        nops(other[1]) <> 3 then
        error("expecting a list of three expressions");
      end_if;
      object::XFunction := other[1][1];
      object::YFunction := other[1][2];
      object::ZFunction := other[1][3];
    end_if;
    
    dom::checkObject(object);
  end_proc:

  
plot::Spherical::print := p -> hold(plot::Spherical)([p::XFunction, p::YFunction, p::ZFunction],
                                                      p::UName = p::URange, p::VName = p::VRange):
     
plot::Spherical::doPlotStatic :=
  proc(out, p, attributes, inheritedAttributes)
    local x, y, z, u, v, cleaned_att;
  begin
    u := attributes[UName];
    v := attributes[VName];
    x := attributes[XFunction];
    y := attributes[YFunction];
    z := attributes[ZFunction]; 
    cleaned_att := out::fixAttributes(attributes, plot::Surface);
    cleaned_att[XFunction] := x * (cos@y) * (sin@z);
    cleaned_att[YFunction] := x * (sin@y) * (sin@z);
    cleaned_att[ZFunction] := x * (cos@z);
    if contains(cleaned_att, LineColorFunction) then
      cleaned_att[LineColorFunction] := 
      subs(((u, v, x, y, z) -> `#f`(u, v,
                                    `#r`(u, v),
                                    `#phi`(u, v),
                                    `#theta`(u, v),
                                    args(3..args(0)))),
           [`#f` = cleaned_att[LineColorFunction],
            `#r` = attributes[XFunction],
            `#phi` = attributes[YFunction],
            `#theta` = attributes[ZFunction]]);
    end_if;
    if contains(cleaned_att, FillColorFunction) then
      cleaned_att[FillColorFunction] := 
      subs(((u, v, x, y, z) -> `#f`(u, v,
                                    `#r`(u, v),
                                    `#phi`(u, v),
                                    `#theta`(u,v),
                                    args(3..args(0)))),
           [`#f` = cleaned_att[FillColorFunction],
            `#r` = attributes[XFunction],
            `#phi` = attributes[YFunction],
            `#theta` = attributes[ZFunction]]);
    end_if;
    out(plot::Surface(op(cleaned_att)), inheritedAttributes, Raw):
  end_proc:
  

