//      

/* -----------------------------------------------------------
    XRotate -- rotate function around the x-axis

    Syntax:
    XRotate(f, var=a..b, <, op1, op2, ...>)

    f, a, b               : arithmetical expressions
    op1, op2, ...         : options of the form 'option = value'

    Example:
    >> plot::XRotate(sin(x), x=0..2*PI)

    >> plot::XRotate(sin(x+a), x=0..2*a+PI, AngleBegin=0, AngleEnd=PI+a/2, a=0..2*PI)
----------------------------------------------------------------*/ 
plot::createPlotDomain("XRotate",
                       "rotate a function around the x axis",
                       3,  // Dimension
   [Function, XName, XMin, XMax,
    [AngleBegin, ["Optional", 0],
     ["Definition", "Expr", FAIL, "Beginning of the angle", FALSE]],
    [AngleEnd,   ["Optional", 2*PI],
     ["Definition", "Expr", FAIL, "End of the angle", FALSE]],
    // library interface for AngleBegin, AngleEnd
    [AngleRange,   ["Library", NIL,
                    plot::libRangeOfOptExpr("Angle"),
                    plot::readRangeOfOptExpr("Angle")],
                    [[AngleBegin..AngleEnd]]],
    UMesh, VMesh, Mesh, USubmesh, VSubmesh, Submesh, AdaptiveMesh,
    MeshVisible,
    ULinesVisible, VLinesVisible, LineStyle, LineColorFunction,
    FillColorFunction, LineWidth, LineColor, Color, LineColorType,
    LineColor2, PointsVisible, PointStyle, PointSize, Filled,
    FillColor, FillColorType, FillColor2, Shading,
    XContours, YContours, ZContours,
    LineColorDirectionX, LineColorDirectionY, LineColorDirectionZ,
    LineColorDirection, FillColorDirection,
    FillColorDirectionX, FillColorDirectionY, FillColorDirectionZ]):
//------------------------------------------------------------------------
plot::XRotate::styleSheet:= table(
     XMin=-5,
     XMax=5,
     LegendEntry = TRUE,
     LineColor = RGB::Black.[0.25],
     LineColorDirectionY=0
):
//------------------------------------------------------------------------
// Hints for parents:
plot::XRotate::hints := {Scaling = Constrained}:
//------------------------------------------------------------------------
plot::XRotate::new :=
proc()
  local object, other, x;
begin
  object := dom::checkArgs(["X"], args());
  
  other := object::other;
  
  if nops(other) > 1 then
    error("unexpected argument: ".expr2text(other[2]));
  end_if;
  
  if nops(other) > 0 then
    object::Function:= other[1];
  end_if;
  
  //---------------------------------------
  // Arrgrr: request by the school fraction.
  //---------------------------------------
  if object::XName = FAIL then
    x:= numeric::indets(object::Function);
    if nops(x) = 0 then
      object::XName:= `#x`;
    elif nops(x) = 1 then
      object::XName:= op(x);
    else error("cannot figure out the name of the independent variable");
    end_if;
  end_if:
  //---------------------------------------
  // end of Arrgrr
  //---------------------------------------

  dom::checkObject(object);
end_proc:
//------------------------------------------------------------------------
plot::XRotate::print :=
  obj -> hold(plot::XRotate)(obj::Function, obj::XName = obj::XRange):
//------------------------------------------------------------------------
plot::XRotate::doPlotStatic:=
proc(out, object, attributes, inherited)
  local surface, f, angle, xname, xmin, xmax;
begin
  angle := `#phi` = attributes[AngleBegin]..attributes[AngleEnd];
  xname := attributes[XName];
  xmin  := attributes[XMin];
  xmax  := attributes[XMax];
  // function is univariate!
  f := attributes[Function]@(x->x);
  attributes := out::fixAttributes(attributes, plot::Surface);
  surface := plot::Surface([xname, f(xname)*cos(`#phi`), f(xname)*sin(`#phi`)],
                           xname = xmin..xmax, angle, op(attributes));
  out(surface, inherited, Raw)
end_proc:
//------------------------------------------------------------------------
