// 
//
// Utility functions:
// convex hull, Delaunay triangulation
//
// uses code from the qhull project
plot::hull :=
proc(L : DOM_LIST, tri=TRUE : DOM_BOOL)
begin
  plot::hull::qhull(float(L), tri);
end:

plot::hull := funcenv(plot::hull):

proc()
  save qhull;
begin
  unprotect(qhull);
  module("qhull");
  plot::hull::qhull := qhull;
end_proc():

plot::delaunay :=
proc(L : DOM_LIST)
  local i, s, maximum, H, avg, r;
  save DIGITS;
begin
  if nops(L) = 0 then
    return(L);
  end;
  DIGITS := 15:
  L := float(L);
  maximum := 0;
  avg := [_plus(s[i] $ s in L)/nops(L) $ i = 1..nops(L[1])];
  // slight jitter
  r := frandom(43228376);
  L := map(L, zip, avg, (a, b) -> a + 1e-4*r()*(b-a));
  L := map(L, l -> l.[_plus(op(zip(l, avg, (x, y)->(x-y)^2)))]);
  maximum := 2*max(map(L, _index, -1));
  H := plot::hull(L.[avg.[2*maximum+1]], TRUE);
  map(select(H, h -> _and(op(map(h, p -> p[-1] < maximum)))),
      map, _index, 1..-2);
end_proc:
