// plot::unapply
//
// simple version of fp::unapply -- essentially the old
// fp::unapply, which has problems on piecewise expressions.
// Those are handled differently here, since we can ignore
// output issues.

plot::unapply :=
proc(e)
  local Args, i;
begin
  if testargs() then
    if args(0) < 1 then
      error("wrong no of args")
    end_if;
    if args(0) > 1 then
      Args:= { args(2..args(0)) };
      // if (nops(Args) <> args(0) - 1) or (Args <> indets(Args)) then
      if map(Args, testtype, Type::Indeterminate) <> {TRUE} then
        error("wrong indeterminates")
      end_if
    end_if
  end_if;

  if e::dom::unapply <> FAIL then
    return(e::dom::unapply(args()))
  end_if;
  
  e := plot::ExprAttribute::getExpr(e);
  
  // get indeterminates 
  if args(0) = 1 then
    Args:= [ op(indets(e) minus Type::ConstantIdents) ]
  else
    Args:= [ args(2..args(0)) ]
  end_if;

  if Args = [] then
    subsop(proc() option arrow; begin end, 4=e, Unsimplified)
  else
    subsop(proc() option arrow; begin end, 1=op(Args),
           4=subs(e, [ Args[i]=DOM_VAR(0,1+i) $ i=1..nops(Args) ],
                  Unsimplified))
  end_if
end_proc:

