// 

// plot::writeMeshContours: plot -- plot contour lines
// for an irregular mesh

plot::writeMeshContours :=
proc(data, ops, contdir, contours,
     linecolorfunction, _min, _max)
  local writeCLine, linearZero, pt, c, p1, p2, p3,
	t, interpol, i;
begin
  contours := float(contours);
  if contours = [] then return(); end_if;
  
  writeCLine :=
  proc(p1, p2)
  begin
    plot::MuPlotML::prP3(op(p1, ops), // the point
			 linecolorfunction(p1));
    plot::MuPlotML::prP3(op(p2, ops), // the point
			 linecolorfunction(p2));
  end_proc;
  
  // linear interpolation over all components
  interpol := (a,b)->t*a+(1-t)*b;
  linearZero :=
  proc(p1, p2)
    local z1, z2;
  begin
    z1 := op(p1, contdir);
    z2 := op(p2, contdir);
    if iszero(z1-z2) then
      p1;
    else
      t := (c-z2)/(z1-z2);
      zip(p1, p2, interpol);
    end_if;
  end_proc;
  
  if contours[1] = hold(Automatic) then
    if nops(contours) > 1 and
       domtype(float(contours[2])) = DOM_FLOAT then
      contours := float(contours[2]);
    else
      contours := 15;
    end_if;
    if contours < 2 then contours := 2; end_if;
    _max := _max - frac(contours)/floor(contours) * (_max - _min);
    contours := floor(contours);
    contours := [_min + i*(_max-_min)/(contours-1)
		 $ i = 0..contours-1];
  end_if; // Automatic
  
  plot::MuPlotML::beginElem("Lines3d",
			    "Type"="Lines",
			    "PointsVisible"=FALSE);
  
  for c in contours do
    pt := 1;
    while pt < nops(data) do // three consecutive points form a triangle
      p1 := data[pt  ];
      p2 := data[pt+1];
      p3 := data[pt+2];
      case [specfunc::sign(c-op(p1, contdir)),
	    specfunc::sign(c-op(p2, contdir)),
	    specfunc::sign(c-op(p3, contdir))]
	of [ 0, 0, 0] do
	  writeCLine(p1, p2);
	  writeCLine(p2, p3);
	  writeCLine(p3, p1); break;
	of [ 0, 0, 1] do
	of [ 0, 0,-1] do writeCLine(p1, p2); break;
	of [ 0, 1, 0] do
	of [ 0,-1, 0] do writeCLine(p1, p3); break;
	of [ 1, 0, 0] do
	of [-1, 0, 0] do writeCLine(p2, p3); break;
	of [ 1,-1, 0] do
	of [-1, 1, 0] do writeCLine(linearZero(p1, p2), p3); break
	of [ 1, 0,-1] do
	of [-1, 0, 1] do writeCLine(linearZero(p1, p3), p2); break
	of [ 0, 1,-1] do
	of [ 0,-1, 1] do writeCLine(linearZero(p2, p3), p1); break
	of [ 1,-1,-1] do
	of [-1, 1, 1] do writeCLine(linearZero(p1, p2), linearZero(p1, p3)); break;
	of [-1, 1,-1] do
	of [ 1,-1, 1] do writeCLine(linearZero(p1, p2), linearZero(p2, p3)); break;
	of [-1,-1, 1] do
	of [ 1, 1,-1] do writeCLine(linearZero(p2, p3), linearZero(p1, p3)); break;
      end_case;
      pt := pt+3;
    end_while;
  end_for;
  
  plot::MuPlotML::endElem("Lines3d");
  
end_proc:

