//      

/*++
    copy -- function to copy an object

    Syntax:

    copy(g)

    g           : graphical objects
   
    Because of the reference system, one can not copy objects by
    using the arrignment-operator ':='. That's why a copy function
    is necessary. It's similar to the effect in C++ when arrays 
    are about to be copied.

    Example:
    >> f := plot::Function(sin(x), x = 0..2)

    >> g := plot::copy( f );

    >> g::Color := RGB::Green;

    >> g::Color; f::Color;
   
    NOTE:
    >> g := f;

    >> g::Color := RGB::Green;

    >> g::Color; f::Color;
   
++*/
plot::copy := proc(o)
    local t;
begin
    if args(0) <> 1 then
        error("expecting one argument")
    elif (t:= o::dom::copy) = FAIL then
        error("invalid argument")
    else
        return( t(o) )
    end_if
end_proc:

/*++
    modify -- function to modify several attributes of an
              object

    Syntax:

    modify(g1 <, op1, op2, ...>)

    g1,           : graphical objects
    op1, op2, ... : plot2d or plot3d options, see plot2d and plot3d for details
   
    By using  m o d i f y  one can modify several attributes of an object instead
    of modifying each attribute by hand. 
    
    IMPORTANT: It returns a modified  C O P Y  of the original object!

    Example:
    >> f := plot::Function(sin(x), x = 0..2)

    >> f := plot::modify( f, Color = RGB::Blue, LineWidth = 12, LineStyle = DashedLines)

    has the effect of:
    >> f::Color := RGB::Blue: 
       f::LineWidth := 12, 
       f::LineStyle := DashedLines:
++*/
plot::modify:= proc(o)
    local t;
begin    
    case args(0)
    of 0 do
        error("no argument given")
    of 1 do
        return( o )
    otherwise
        if (t:= o::dom::modify) = FAIL then
            error("invalid argument")
        else
            return( t( args() ) );
        end_if
    end_case
end_proc:

