//   

/*--
faclib::bound -- get the upper bound of factors of input univariate polynomial,
		 output is a positive floating-point number

                 [1] Maurice Mignotte, Mathematics for computer algebra, page 
                 295, Springer-Verlag New York, Inc.,1992
                 [2] Polynomial Factorization: Sharp Bounds, Efficient
		     Algorithms, B. Beauzamy, V. Trevisan, P. S. Wang
  
faclib::bound(a):
a - a square free univariate polynomial
--*/


// original (correct) version of yuan

faclib::bound:=
proc(a)
  name faclib::bound;
  local d;
begin
  d:=degree(a);
  2^(1 + (d div 2))*ceil(float(sqrt(2^(d mod 2)*(1 + d))))*norm(a)*
  abs(lcoeff(a))
end_proc:




//
// wrong, because we use rational number reconstruction !!
//


/*
faclib::bound:=proc(a)
local n,m,z,C,i,lc,m2,b,wn;
begin
    n:=degree(a); 
    if n<=1 then return(1) end_if;
    a:=mapcoeffs(a,float); 
    wn:=_plus(coeff(a,i)^2/binomial(n,i)$i=0..n)^(1/2);
    lc:=abs(lcoeff(a));
    /* return a single-factor bound, i.e. a bound on the
      "smallest" factor of a, cf [2], Corollary 4 */
    return((if n=2 then 2*lc*3.0^(n/2+3/4)/2/sqrt(float(PI*n))*wn
    else 2.2*lc*2.0^(n/2)/n^(3.0/8)*wn^(1/2) end_if));
    /* WARNING: the following code is not currently used, but may be
      useful. Don't remove it */
    /* but uncommenting must be ok? */

    /*             
                 
    // Beauzamy bound comes from [2] 
    m:=3.0^(n/2+3/4)/2/sqrt(float(PI*n))*wn;
    // Mignotte bound 
    b:=2.0^(n div 2)*ceil(float(sqrt(2^(n mod 2)*(1+n))))*norm(a);
    if b<m then userinfo(1,"Mignotte bound is better :",b<m); m:=b end_if;
    // Zassenhaus' bound comes from [2] 
    C:=1/(2.0^(1/n)-1)*max(abs(float(coeff(a,n-i))/lc/binomial(n,i))^(1/i)$i=1..n);
    z:=max(binomial(n div 2,i)*C^i$i=1..n div 2);
    if z<m then userinfo(1,"Zassenhaus bound is better : ",z<m); m:=z end_if;
    // Mignotte's bound 2 comes also from [2] 
    m2:=binomial(n,n div 2)*norm(a,2);
    if m2<m then userinfo(1,"Mignotte bound 2 is better :",m2<m); m:=m2 end_if;
    2.0*lc*m

    */
end_proc:

*/
