//   

/*--
faclib::canzas_2 -- split the product of all monic irreducible factors of degree
                    i in Zp when p=2, via Cantor-Zassenhaus method (see Keith O.
                    Geddes, Stephen R. Czapor and George Labahn, Algorithms for
                    computer algebra, page 373, Kluwer Academic Publishers,
                    1992), output is a set of factors in polynomial form.

faclib::canzas_2(fpoly,i,x) 
fpoly - a univatiate polynomial, it is the product of all monic irreducible
        factors of degree i in Zp (p=2)
i - a positive integer number 
x - the indeterminate
--*/

faclib::canzas_2:=proc(fpoly,i,x)
local d, f, m, pp,j ;
save SEED;
begin
    SEED:= 1;
    userinfo(3, "Cantor-Zassenhaus equal degree factorization ".
	        "for characteristic 2 called");
    if (d:=degree(fpoly))=i then 
       userinfo(8, "Only one factor");
       return({fpoly});
    end_if; 
    userinfo(5, "Input degree is ".expr2text(d));
    userinfo(5, "Splitting into factors of degree ".expr2text(i));
    repeat 
	   pp:=poly(_plus(((SEED:=427419669081*SEED mod 999999999989) mod   
       2)*x^m $ m=0..2*i-2)+x^(2*i-1),[x],IntMod(2));
     m:=pp;
     for j from 2 to i do m:=divide(m*m,fpoly,Rem); pp:=pp+m end_for;
	   pp:=faclib::univ_mod_gcd(fpoly,pp);
           if degree(pp)>0 and pp<>fpoly then
              f:=faclib::canzas_2(pp,i,x) union
                 faclib::canzas_2(divide(fpoly,pp,Quo),i,x);
	   else
	      userinfo(8, "Split did not succeed");
	      f:=FAIL
           end_if;
    until /* nops(f)=d/i */ f<>FAIL end_repeat;
    f;
end_proc:



