/*--
faclib::combine -- get the true factors in Z through the combination of the
                   factors in Zp, the algorithm of generation of combinations 
                   (k subsets) in lexicographic order can be found on page 181
                   of Edward M. Reingold, Jurg Nievergelt, Narsigh Deo,
                   Combinatorial algorithm, theory and pratice, Prentice-Hall,
                   Inc., 1977, output is a list of factors in polynomial form. 

faclib::combine(a,lc,f,p,pos_grad,kmax) 
a - a square free polynomial in Z
lc - lcoeff(a)
f - a list of polynomials in Z, they are the factors of a in Zp
p - a positive integer number
pos_grad - a set of positive integer number, they are the possible degrees of
           the factors of a in Z
kmax - a positive integer number, the maximum number of elements of
	subsets of factors to be tried
--*/

// lst = TRUE iff this is the last combine 
faclib::combine:=
proc(a,lc,f:DOM_LIST,p,pos_g,kmax:DOM_INT,po,pow,lst)
  local b, c, fs, i, j, k, l, lt, n, n0, pf, pos, u, fg, z, sfb, wn, d, t;
begin
  // remove those coeffs of x^(n-1) which are "too" big 
  if lst=FALSE then
    f:=select(f,proc()
                begin
                  3*abs(coeff(args(1),degree(args(1))-1))<p
                end_proc )
  end_if;
  fs:=[];
  n:=nops(f); d:=degree(a);
  userinfo(1,"combining ".n." factors in F_".po."^".pow.
           " of polynomial of degree ".d);
  fg:=map(f,degree);
  userinfo(1,"factors in F_".po."^".pow." have degrees",op(fg));
  userinfo(1,"possible degrees of factors in Z are",op(sort([op(pos_g)])));
  u:=genident();
  z:=genident();
  fg:=expand(_mult(1+u*z^fg[k]$k=1..n));
  lt:=lc*tcoeff(a);
  k:=2; // try all k-subsets of n factors 
  // weighted norm, cf Beauzamy-Trevisan-Wang (see bound.mu) 
  wn:=_plus(abs(float(coeff(a,i)))$i=0..d)^(1/2);
  sfb:=1.1*2.0^(d/2)/d^(3.0/8)*wn; // single-factor bound 
//  while 2*k<=min(n,2*kmax) do
  while k<=min(ceil(n/2),kmax) do
    userinfo(1,"trying to combine ".k."-subsets of factors");
    c:=coeff(fg,[u],k);
    if type(c)="_plus" then
      c:=op(c)
    end_if;
    c:=map({c},degree);
    if c intersect pos_g={} then
      userinfo(1,"not possible from degree analysis");
    else
      c:=array(0..k,(0)=-1);
      for i from 1 to k do c[i]:=i end_for;
      j:=1;
      while j>0 do
        pos:=FALSE;
        // to see if the combination of these factors is a true factor, 
        // instead of doing polynomials division directly, at first     
        // check if it has the possible degree, then check if its tcoeff
        // and lcoeff divide that of polynomial to be factorized        
        if contains(pos_g,_plus(degree(f[c[l]])$l=1..k)) then
          /* if the coeff. of x^(n-1) in the product of factors
              is greater than the single-factor bound, it can't be
              the factor with smallest norm */
          t :=  mods(lc*_mult(coeff(f[c[l]],0)$l=1..k),p);
          if t <> 0 and lt mod t = 0 
            then
            pf:=faclib::primpart(poly(multcoeffs(
                                                 _mult(f[c[l]]$l=1..k),lc),Expr));
            if lc mod lcoeff(pf)=0 then
              if (b:=divide(a,pf,Exact))<>FAIL then
                pos:=TRUE;
                userinfo(1,"factors",c[l]$l=1..k,
                         "of degrees",degree(f[c[l]])$l=1..k,
                         "combine at time ".time());
                userinfo(2,"resulting factor is",expr(pf));
              end_if;
            end_if;
          end_if;
        end_if;
        if pos then
          fs:=append(fs,pf);
          n:=n-k;
          userinfo(1,"remains ".n." factors to combine");
          if n<2*k then return(append(fs,b)) end_if;
          a:=b;
          lc:=lcoeff(a);
          lt:=lc*tcoeff(a);
          // rearrange the other factors and c, 
          // then combine them for the next j   
          for i from 1 to k do
            delete f[c[i]-i+1];
          end_for;
          if (n0:=c[1]-1)<n-k then
            for i from 1 to k do
              c[i]:=n0+i;
            end_for;
          else
            j:=0;
          end_if;
        else
          j:=k;
          while c[j]=n-k+j do
            j:=j-1;
          end_while;
          if 2*k=n and j=1 then
            break;
          else
            c[j]:=c[j]+1;
          end_if;
          for i from j+1 to k do
            c[i]:=c[i-1]+1;
          end_for;
        end_if;
      end_while;
    end_if;
    k:=k+1;
  end_while;
  append(fs,a)
end_proc:
