//           

// stefanw, 20.11.1995 




//  distdegr.mu 
//  distinct-degree factorization over finite fields 
//  input : polynomial f 
//  output: list [f1,...,fn] 
//  where f.i is the product of all irreducible factors of f whose degree is i 
//  and n is the degree of the largest factor(s) of f  




faclib::distdegr:=proc(f)
local size,F,x,i,l,m,lst,p,xqi,pol,dim,j;

begin
if domtype(f)<>DOM_POLY then error("Argument must be polynomial"); end_if;
F:=op(f,3);
case domtype(F) 
    of DOM_DOMAIN do
        if F::constructor=Dom::GaloisField then size:=F::size
        elif F::constructor=Dom::IntegerMod then size:=F::characteristic
        else error("Illegal argument");
        end_if;
        break;
    of DOM_EXPR do
        if not has(F,IntMod) then error("Illegal argument"); end_if;
        size:=op(F);
        break;
    otherwise error("Illegal argument");
end_case;

x:=op(f,[2,1]);
pol:=poly(x,[x],F);
dim:=degree(f)-1;
xqi:=pol;

lst:=[];
i:=1;
m:=[faclib::powermod_poly(pol,size,f)];
for l from 2 to dim do
	 m:=append(m, divide(m[l-1]*m[1],f,hold(Rem)));
end_for;
while degree(f)  >= i * 2  do
	xqi:=poly(coeff(xqi,0),[x],F)+
        _plus(multcoeffs(m[j],coeff(xqi,j))$j=1..dim);
      // same effect as xqi:=faclib::powermod_poly(xqi,size,f); 
	p:=faclib::univ_mod_gcd(f,xqi-pol);
	lst:=lst.[p];
	f:=divide(f,p,hold(Quo));
        i:=i+1;
end_while;

if degree(f)=0 then return(lst);
elif degree(f)<i then return(lst.[f]) 
else return(lst.[ poly(1,[x],F) $degree(f)-i ].[f]);
end_if;

end_proc:
        	
	
	

