// p is a polynomial (DOM_POLY) whose 3rd operand is neither Expr nor IntMod(...) 
faclib::domfact :=
proc(p)
  local q,xx,i;
begin
  q:=op(p,3);
  // since polylib::Poly has no hasProp - method ...
  if eval(op(level(q::key,1),0))=polylib::Poly then
    xx:=factor(poly(p,op(p,2).(q::indets),q::coeffRing));
    xx:=Factored::convert_to(xx,DOM_LIST);
    for i from 2 to nops(xx) step 2 do
      xx[i]:=poly(xx[i],op(p,2..3));
    end_for;
    xx
  elif q::constructor=Dom::IntegerMod and nops(op(p,2))=1 then
    xx:=IntMod(q::size);
    p:=subs(Factored::convert_to(factor(subsop(p,3=xx)),DOM_LIST),xx=q);
    subsop(p,1=q(p[1]))
  elif q=Dom::Rational or q=Dom::Integer or q::constructor=Dom::ExpressionField then
    subs(Factored::convert_to(factor(poly(p,Expr)),DOM_LIST),Expr=q)
  elif q::constructor=Dom::AlgebraicExtension and nops(op(p,2))=1 then
    faclib::algfactor(p,TRUE)
  elif q::constructor=Dom::GaloisField and nops(op(p,2))=1 then
    faclib::factorgf(p)
  elif q::constructor=Dom::Fraction then
    faclib::fracfact(p)
  elif q::hasProp(Cat::Field) then
    if nops(op(p,2))>1 then
      faclib::multifactor(p)
    else
      error("cannot factor univariate polynomials over arbitrary fields")
    end_if
  elif q::constructor=Dom::DistributedPolynomial
    or q::constructor=Dom::UnivariatePolynomial
    or q::constructor=Dom::MultivariatePolynomial
    then
    xx:=factor(poly(p,[op(indets(expr(p)))], q::coeffRing));
    xx:=Factored::convert_to(xx,DOM_LIST);
    xx[1]:=q(xx[1]);
    for i from 2 to nops(xx) step 2 do
      xx[i]:=poly(xx[i], op(p,2..3));
      if degree(xx[i])=0 then // belongs to coefficient ring 
        xx[1]:=xx[1]*coeff(xx[i],0)^xx[i+1];
        xx[i]:=FAIL;
        xx[i+1]:=FAIL
      end_if
    end_for;
    select(xx, _unequal, FAIL)
  elif q::constructor=Dom::Polynomial then
    xx:=factor(poly(p, [op(indets(expr(p)))], q::coeffRing));
    xx:=Factored::convert_to(xx,DOM_LIST);
    xx[1]:=q(xx[1]);
    for i from 2 to nops(xx) step 2 do
      xx[i]:=poly(xx[i], op(p,2..3));
      if degree(xx[i])=0 then // belongs to coefficient ring 
        xx[1]:=xx[1]*coeff(xx[i],0)^xx[i+1];
        xx[i]:=FAIL;
        xx[i+1]:=FAIL
      end_if
    end_for;
    select(xx, _unequal, FAIL)
  else
    error("can only factor over fields or polynomial rings")
  end_if
end_proc:
