/*--
faclib::eval_root -- get the linear factors of a univariate square free
                     polynomial in Zp by evaluation of polynomial in Zp, output
                     is a list of factors in polynomial form in Zp.

faclib::eval_root(a,p,x)
a - a univeriate square free polynomial in Zp[x]
p - a prime number
x - the indeterminate
--*/

faclib::eval_root:=proc(a,p,x)
local i, root;
begin
    root:=[];
    for i from 0 to p-1 do
        if evalp(a,x=i)=0 then 
           root:=append(root,poly(x-i,IntMod(p)));
           // since this procdure is used by faclib::ufactor after using  
           // faclib::ddf, a(x) is the product of all the linear factors, 
           // the number of roots here equals the degree of a(x)          
           if nops(root)=degree(a) then 
              return(root); 
           end_if;
        end_if;
    end_for;
end_proc:
