//     

/*--
faclib::factor_mod_composite -- return the factorization of univariate
				 polynomial in Zn, if it is unique.
                      

faclib::factor_mod_composite(f,x,n)
f - a univariate polynomial in Zn
x - the indeterminate
n - the modulus


--*/


faclib::factor_mod_composite:=proc(f,x,n)
local i,nfact,primefactors,modfact,primepowers,multiplicities; 

begin
if isprime(n) then return(faclib::factor_mod(args())) end_if;
nfact:=stdlib::ifactor(n);
primefactors:=[op(nfact,2*i) $i=1..nops(nfact) div 2];
// get factorizations modulo prime powers 
multiplicities:=[op(nfact,2*i+1) $i=1..nops(nfact) div 2];
primepowers:=zip(primefactors,multiplicities,_power);
modfact:=zip(primefactors,multiplicities,proc() begin 
	faclib::factor_mod_power
	(poly(f,[x],IntMod(args(1)^args(2))),x,args(1),args(2)) end_proc );

// now modfact contains a list of modular factorizations 
// Chinese Remainder Theorem  
zip(primepowers,modfact, proc() begin op(map([[args(2)[2*i-1],args(2)[2*i]] 
	$i=1..nops(args(2)) div 2], 
	faclib::polychr,n div args(1),args(1))) end_proc )
end_proc:
 
/*--
faclib::polychr -- perform Chinese remainder algorithm on the coefficients
	of a polynom
				 
                      

faclib::polychr(a,m,n)
a - pair of polynom and integer [f,k]
m,n - the moduli

returns the pair g,k where g is a polynomial over IntMod(m*n)
which solves g \equiv 1 \bmod m and g \equiv f \bmod n

--*/


faclib::polychr:=proc(a,m,n)
local f;

begin
f:=poly(op(a,1),IntMod(m*n));
mapcoeffs(f-poly(coeff(f,0),op(f,2),IntMod(m*n)),proc() begin numlib::ichrem([0,args(1)],[m,n]) end_proc )
+poly(numlib::ichrem([1,coeff(f,0)],[m,n]),op(f,2),IntMod(m*n)),   op(a,2)
end_proc:

/*--
faclib::factor_mod_power -- factorization over IntMod(p^n)
				 
                      

faclib::factor_mod_power(f,x,p,n)
f - polynom 
x - indeterminate
p - prime number
n - positive integer

returns a list [f1,a1, \ldots fk,ak] where f = \prod f_i^{a_i}
can only deal with f that are squarefree modulo p at the moment

--*/

faclib::factor_mod_power:=proc(f,x,p,n)
local fi, s, t, e, fprod, i, j, k, Factors, q, r,newf;

begin
if lcoeff(f) mod p = 0 then 
	error("Leading coefficient is not a unit");
end_if;
newf:=poly(f,[x],IntMod(p));
Factors:=factor(newf);
Factors:=Factored::convert_to(Factors,DOM_LIST);
Factors[2]:=multcoeffs(Factors[2],Factors[1]);
delete Factors[1];
if n=1 then return(Factors) end_if;
if { Factors[2*i] $i=1..nops(Factors) div 2} <> {1} then
	error("Not squarefree modulo ".expr2text(p));
end_if;
if nops(Factors)=2 then return([f,1]) end_if;
fi:=[Factors[2*i-1] $i=1..nops(Factors) div 2]; 
// calculate over Expr, sine the modulus changes in every step ? 

// determine the si  
fprod:=fi[1]*fi[2];
t:=gcdex(fi[2],fi[1]);  // sic! 
s:=[ op(t,2..3) ];
// loop invariant: fprod = f1 * ... * fj 
for j from 3 to nops(fi) do 
        t:=gcdex(fprod,fi[j]);
        for k from 1 to j-1 do
                s[k]:=s[k]*op(t,3);
        end_for;
        s:=append(s,op(t,2)); 
        fprod:=fprod*fi[j];
end_for;
 s:=zip(s,fi,proc() begin divide(args(1),args(2),hold(Rem)) end_proc ); 


for j from 2 to n do // Hensel lifting 
	s:=map(s,poly,IntMod(p^j));
	fi:=map(fi,poly,IntMod(p^j));
	e:=poly(f,IntMod(p^j))-_mult(op(fi));
	for i from 2 to nops(fi) do 
                q[i]:=divide(e*s[i],fi[i]);
                r[i]:=op(q[i],2);
                q[i]:=op(q[i],1);
                fi[i]:=fi[i]+r[i];
        end_for;
        r[1]:=s[1]*e+fi[1]*(_plus(q[k] $k=2..nops(fi)));
        fi[1]:=fi[1]+r[1];
end_for;


 [(fi[i],1) $i=1..nops(fi)] 
end_proc:
	
