//   

/*--
faclib::factor_mod -- return the factorization of univariate polynomial in Zp,
                      output is a list of factors in polynomial form in Zp.

faclib::factor_mod(a,x,p)
a - a univariate polynomial in Zp
x - the indeterminate
p - the prime number

faclib::factor_mod get the factors with different powers, then factorize these 
square free factors into distinct degree factors, and then split them
--*/

faclib::factor_mod:=
proc(a,x, p)
  local d, Factors, fd, ff, fi, fs, i, m, DDF;
begin
  Factors:=[];
    // factorize into square free factors at first 
  fs:=faclib::sqrfreeff(a,x,p);
  for i from 1 to nops(fs)/2 do
    d:=op(fs,2*i);
    if degree((ff:=op(fs,2*i-1)))=1 then
      Factors:=append(Factors,ff,d);
    else
      DDF:=faclib::choose_ddf(degree(ff),p);
      fd:=DDF(ff,p,x);
      if fd[1][1][2]=1 then
                // for linear factors, evalution method is more efficient 
        if degree(fd[1][1][1])=1 then
          fi:= [fd[1][1][1]];
        else
          fi:= faclib::canzas_lin(fd[1][1][1],p,x)
          // faclib::eval_root(fd[1][1][1],p,x);
        end_if;
        delete fd[1][1];
      else
        fi:=[]
      end_if;
      // for nonlinear factors, use Cantor-Zassenhaus method to split
      if p=2 then
        // using faclib::canzas_2 for case p=2 to simplify computation
        for m from 1 to nops(fd[1]) do
          if degree(op(fd[1][m],1))=op(fd[1][m],2) then
            fi:=append(fi,op(fd[1][m],1));
          else
            fi:=append(fi,op(faclib::canzas_2(op(fd[1][m]),x)));
          end_if;
        end_for;
      else
        // use faclib::canzas for p>2 cases
        for m from 1 to nops(fd[1]) do
          if degree(op(fd[1][m],1)) = op(fd[1][m],2) then
            fi:= append(fi,op(fd[1][m],1));
          else
            fi:= append(fi,op(faclib::canzas(op(fd[1][m]),fd[2],p,x)));
          end_if;
        end_for;
      end_if;
      Factors:= append(Factors,(op(fi,i),d)$i=1..nops(fi));
    end_if;
  end_for;
end_proc:

faclib::choose_ddf:=
proc(n: Type::PosInt, p: Type::Prime) 
// chooses the best algorithm to factorize a polynom of degree n modulo a prime p 
  local n_over_logp: DOM_FLOAT;
begin
  n_over_logp := float(n*ln(2)/ln(p));
  if 0.5<n_over_logp and n_over_logp<2.0 then
    faclib::ddf_shoup
  else
    faclib::ddf
  end_if
end_proc:
