/*--
faclib::indsort -- sort variables of polynomial according to ascending degrees,
                   output is the polynomial written in the order of sorted
                   variables.  

faclib::indsort(p)
p - a multivariate polynomial

faclib::indsort may be called by faclib::pfactor many times
with same polynomial, so set "option remember"
--*/

faclib::indsort:=proc(p)
option remember;
begin
   poly(p,sort(op(p,2),proc(a,b) begin bool(degree(p,a)<degree(p,b)) end_proc));
end_proc:

