//    

/*--
faclib::irr_test -- test the irreducibility of input univariate polynomial
                    by using Eisenstein's irreducibility criterion(see David
                    Sharpe, Rings and factorization, Cambridge University Press,
                    1987) at first, then using a heuristic algorithum(see 
                    Michael B. Monagan, J.Symbolic Computation (1992)13, 47-57).
                    Output is the logical result TRUE(irreducible) or
                    FALSE(reducible).

faclib::irr_test(a,x)
a - a primitive univariate polynomial
x - the indeterminate

faclib::maxdiv -- give the logical result of primitive of the 
		  maximum divisor(<=d)
                  of the input positive integer number n 

faclib::maxdiv(n,d)
n - a positive integer number
d - a positive integer number

faclib::maxdiv may be called by faclib::irr_test(heuristic algorithum) many times
with the same input, so set "option remember"
--*/

faclib::irr_test:=proc(a,x)
local b, d, f, fi, g, i, u;
begin
    // Eisenstein's irreducibility criterion is used at first 
    if (b:=igcd(0,0,nthcoeff(a,i)$i=2..nterms(a)-1))<>1 then 
       if (g:=igcd(b,coeff(a,0)))<>1 then 
          fi:=stdlib::ifactor(g, UsePrimeTab);     
          fi:=[op(fi,i*2)$i=1..floor(nops(fi)/2)];
	  if not isprime(fi[nops(fi)]) then
		delete fi[nops(fi)]
	  end_if;
          for i in fi do 
              if lcoeff(a) mod i>0 and coeff(a,0) mod (i*i) >0 then
                 return(TRUE);
              end_if;
          end_for;
       end_if;
       if (g:=igcd(b,lcoeff(a)))<>1 then 
          fi:=stdlib::ifactor(g, UsePrimeTab);
          fi:=[op(fi,i*2)$i=1..floor(nops(fi)/2)];
	  if not isprime(fi[nops(fi)]) then
                delete fi[nops(fi)]
          end_if;
          for i in fi do
              if coeff(a,0) mod i>0 and lcoeff(a) mod (i*i) >0 then 
                 return(TRUE);
              end_if;
          end_for;
       end_if;
    end_if;
    // if does not get TRUE above, heuristic algorithum follows 
    d:=degree(a);
    if lcoeff(a)>=abs(coeff(a,0)) then
       b:=1+trunc(norm(a)/lcoeff(a));
    else b:=1+trunc(norm(a)/abs(coeff(a,0)));
         a:=poly(expand(_power(x,d)*subs(op(a,1),x=1/x)));
    end_if;
    f:=igcd(evalp(a,x=i)$i=0..d);
    if (u:=abs(evalp(a,x=-b-f)/f))>_power(10, d+5) then 
       return(FALSE);
    elif faclib::maxdiv(u,f) then
         return(TRUE);
    else if (u:=abs(evalp(a,x=b+f)/f))>_power(10, d+5) then 
            return(FALSE);
         else return(faclib::maxdiv(u,f));
         end_if;
    end_if;
end_proc:



faclib::maxdiv:=proc(n,d)
option remember;
begin
    if n mod d=0 then 
       return(isprime(n/d));
    else faclib::maxdiv(n,d-1);
    end_if;
end_proc:
