
// faclib::is_irred_gf(pol) :  tests whether pol is irreducible  
// pol: polynomial over IntMod(p) or Dom::IntegerMod(p) or Dom::GaloisField 
// pol must be in one variable 

faclib::is_irred_gf:=proc(pol)
	local f,g,l,m,n,p,R,x,j;

	begin
	if degree(pol) = 0 then return(FALSE) end_if;
	R:=op(pol,3);
        x:=op(pol,[2,1]);
        case domtype(R) 
	of DOM_EXPR do   // R = IntMod(p) 
		p:=op(R);
		break;
	of DOM_DOMAIN do
		if R::constructor= Dom::GaloisField then
			p:= R::size;
		else  // Dom::IntegerMod 
			p:= R::characteristic;
		end_if;
	end_case;
	

	

	n:=degree(pol);
	
	g:=poly(x,[x],R);
        f:=g;
	m:=[faclib::powermod_poly(poly(x,[x],R),p,pol)];
	for l from 2 to n-1 do
		 m:=append(m, divide(m[l-1]*m[1],pol,hold(Rem)));
	end_for;
	for l from 1 to n/2 do 
		f:=poly(coeff(f,0),[x],R)+
                  _plus(multcoeffs(m[j],coeff(f,j))$j=1..n-1);
	        // test whether there is irred. factor of a degree dividing l 
                // now f=g^(p^l) (modulo pol) 
		if degree(gcdlib::univ_mod_gcd(pol,f-g)) <> 0 then 
			return(FALSE);
		end_if;
	end_for;
	TRUE;

	
	end_proc:


/* faclib::random_irred_gf(P,n) : random (evenly distributed) monic irreducible
 polynomial of degree n over P */  
// P: Dom::IntegerMod(p) or IntMod(p) or Dom::GaloisField 

faclib::random_irred_gf:=proc(P,n: Type::PosInt)
	option remember;
	local pol,x;

	begin
	if testargs() then 
		case domtype(P)
		of DOM_DOMAIN do
			if not P::hasProp(Dom::IntegerMod)  
			and not P::hasProp(Dom::GaloisField) then
				error("First argument must be IntMod(p)
					 or Dom::IntegerMod or Dom::GaloisField")
			elif not P::hasProp(Cat::Field) then
				error("Characteristic is not prime");
			end_if; 
			break;

	
	
		of DOM_EXPR do 
			if not has(P,IntMod) then 
				error("Only allowed expression is IntMod(p)");
			elif not isprime(op(P)) then 
                                error("Prime number requested");
		        end_if;
			break;
		otherwise  error("Illegal first argument");
		end_case;

	end_if;   // end of argument - testing 

        
        //   Find a variable that is not used 
        
        x:=genident();
        
        /* choose poly by random and test it until
          an irreducible one is found */ 
	
	repeat
		pol:=polylib::randpoly([x],P,Degree=n-1,Terms=infinity);
		pol:=pol+poly(x^n,P)
	until faclib::is_irred_gf(pol)
	end_repeat;

      	
	return (pol);
	end_proc:


// end of file 
