//    

/*++ 	faclib::kronecker_factor(f)
	
	factors a squarefree multivariate polynomial f by 
	reducing the problem to univariate factoring 
	(Kronecker substitution).

++*/


faclib::kronecker:=proc(f,n)
// substitutes op(f,[2,j]) by op(f,[2,1]^((j-1)*n)) for each j 

begin
poly(
map(poly2list(f),proc() local k; 
   begin 
   subsop(args(1),2=_plus(args(1)[2][k]*n^(k-1) 
   $k=1..nops(args(1)[2]))) 
   end_proc ),
[op(f,[2,1])],op(f,3))
end_proc:


faclib::invkronecker:=proc(f,varlist,n)
// replaces op(f,[2,1])^(j*n+1)) by varlist[j] 
begin
poly(
map(poly2list(f),
   proc() 
   local k;
   begin 
   subsop(args(1),2=[args(1)[2]
     mod (n^k) div (n^(k-1)) $k=1..nops(varlist)+1]) 
   end_proc ),
op(f,2).varlist,op(f,3))
end_proc:


faclib::kronecker_factor:=proc(argf)
local f,ff,j,n,l,result,onefactor,factorsleft,st;

begin
f:=argf; // to avoid warnings 
if nops(op(f,2))<2 then
	error("Polynomial must be multivariate");
end_if;
n:=max(degree(f,j) $j in op(f,2))+1;
userinfo(1,"Kronecker substitution of variables");
userinfo(2,"n=".expr2text(n));
ff:=faclib::kronecker(f,n);
userinfo(2,"Degree of univariate image: ".expr2text(degree(ff)));
st:=time();
l:=factor(ff);
l:=Factored::convert_to(l,DOM_LIST);
userinfo(1,"Time for univariate factorization: ".expr2text(time()-st));
result:=[l[1]];
l:=[op(l,2*j) $j=1..nops(l) div 2];
userinfo(2,"Image has ".expr2text(nops(l))." factors");
st:=time();
factorsleft:={$1..nops(l)};
repeat
	onefactor:=faclib::tryall2(f,l,n);
	userinfo(3,"Found one factor: ".expr2text(op(onefactor,1)));
	result:=append(result,op(onefactor,1),1);
	f:=divide(f,op(onefactor,1),hold(Exact));
	factorsleft:=factorsleft minus op(onefactor,2);
	l:=[l[j] $j in factorsleft];
	factorsleft:={$1..nops(l)}
until l=[] end_repeat;	
userinfo(1,"Time for recombination: ".expr2text(time()-st));
result
end_proc:

faclib::tryall2:=proc(f,flist,n)
local l,g,gg,j,k;

begin
l:={op(combinat::powerset({$1..nops(flist)}))} minus {{}};
l:=sort([op(l)],proc() begin nops(args(1))<nops(args(2)) end_proc );
        // now l is the list of subsets of 1..nops(flist), sorted by size 
for j from 1 to nops(l) do
        userinfo(5,"Trying subset ".expr2text(l[j]));
	g:=faclib::invkronecker(_mult(op(flist,k) $k in l[j]),subsop(op(f,2),1=null()),n);
// try to divide trailing coefficients first 
        gg:=divide(coeff(f,op(f,[2,1]),0),coeff(g,op(f,[2,1]),0),hold(Exact)); 
        if gg<>FAIL then
                gg:=divide(f,g,hold(Exact))
        else
                userinfo(5,"FAIL on division of trailing coefficients")
        end_if;
        if gg<>FAIL then
                // factor found 
        return(g,l[j]);
        end_if
end_for;
FAIL
end_proc:
