/*--
faclib::linear -- get the linear factors of input polynomial in Z by using
                  the algorithm IPRZL from R. Loos, "Rational zeros of integral
                  polynomials by p-adic expansions", SIAM J. of Computing 12,
                  page 286-293(1983).  Output is given in form [the prime
                  number used in this procedure(it maybe useful for ufactor.mu),
                  input polynomial/(mutiplication of all linear factors), linear
                  factors(if there exist any)].

faclib::linear(a,x)
a - a primitive square free univariate polynomial
x - the indeterminate
--*/

faclib::linear:=proc(a,x)
local ap, b, bf, fs, i, lc, nr, root, rp, p, p0, pj;
begin
    lc:=lcoeff(a);
    b:=polylib::Dpoly([1],a); // b:=diff(a,x); 
    p:=1;
    // get the suitable prime number so that a(x) in Zp is square 
    // free and has the same degree as a(x) in in Z               
    repeat 
	p:=faclib::getprime(lc,p);
    until degree(gcd((ap:=poly(a,IntMod(p))),poly(b,IntMod(p))))=0 end_repeat;
    // get the root of a(x) in Zp by evaluation 
    userinfo(4, "Computing roots modulo ".expr2text(p));
    root:=[];
    for i from 0 to p-1 do
        if evalp(ap,x=i)=0 then 
           root:=append(root,i);
        end_if;
    end_for;
    if (nr:=nops(root))=0 then 
	 userinfo(4, "No linear factors exist");
	 return([p,a])
    else p0:=p;
         // lift the roots from Zp to Zpn 
         bf:=2*abs(lc*tcoeff(a));
         while p<=bf do
               pj:=p^2;
	       userinfo(4, "Lifting to root modulo ".expr2text(pj));
               root:=map(map(root,modp,p),
                         proc(xx) begin 
                             xx-p*mods(((evalp(poly(a,IntMod(pj)),x=xx) mod pj)
                                div p)/evalp(poly(b,IntMod(p)),x=xx),p);
                         end_proc);
               p:=pj;
         end_while; 
    end_if;
    fs:=[];
    // check the roots to see if they are also the roots of a(x) in Z 
    for i from 1 to nr do
        // rp:=faclib::primpart(mapcoeffs(poly(lc*(x-root[i])),mods,p)); 
	/* do not apply mods on -root[i] because mods(-r,p) <> -mods(r,p)
	  for example take r=1 and p=2 */
	rp:=faclib::primpart(poly(mods(lc,p)*x-mods(lc*root[i],p)));
        if lc mod lcoeff(rp)=0 then
           if tcoeff(a) mod tcoeff(rp)=0 then
              if (b:=divide(a,rp,Exact))<>FAIL then 
                 fs:=append(fs,rp);
                 a:=b;
              end_if;
           end_if;
        end_if;
    end_for;
    [p0,a].fs;
end_proc:
         
