/*--
faclib::mod_gcd_ex -- return two polynomials s and t thay satisfy s*a+t*b=1 by
                      using extended Euclidean algorithm (see Alkiviadis G.
                      Akritas, Elements of computer algebra with applications,
                      page 124, John Wiley & Sons, Inc., 1989).  Output is a
                      list of these two polynomials.
                 
faclib::mod_gcd_ex(a,b)
a, b - two univariate polynomials in Zp and relatively prime

faclib::mod_gcd_ex may be called by faclib::diophant2(in diophant.mu) many times
with the same input, so set "option remember" 
--*/

faclib::mod_gcd_ex:=proc(a,b)
local i, q, s, st, t;
option remember;
begin
    s:=[b,subsop(b,1=0),subsop(b,1=1)];
    t:=[a,s[3],s[2]];
    while not iszero(t[1]) do 
          q:=divide(s[1],t[1],Quo);
          st:=t;
          t:=[(s[i]-q*t[i])$i=1..3];
          s:=st;
    end_while;
    [multcoeffs(s[i],1/lcoeff(s[1]))$i=2..3];
end_proc:
